// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CHAPTER_INFORMATION_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CHAPTER_INFORMATION_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MediaImage;

class MODULES_EXPORT ChapterInformationInit : public bindings::InputDictionaryBase {
  
  public:
static ChapterInformationInit* Create() {
  return MakeGarbageCollected<ChapterInformationInit>();
}
static ChapterInformationInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ChapterInformationInit>(isolate);
}
static ChapterInformationInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ChapterInformationInit();
explicit  ChapterInformationInit(v8::Isolate* isolate);

bool hasArtwork() const {
  return true;
}
const HeapVector<Member<MediaImage>>& artwork() const {
  return member_artwork_;
}
void setArtwork(const HeapVector<Member<MediaImage>>& value);
void setArtwork(HeapVector<Member<MediaImage>>&& value);

bool hasStartTime() const {
  return true;
}
double startTime() const {
  return member_start_time_;
}
void setStartTime(double value) {
  member_start_time_ = value;
}

bool hasTitle() const {
  return true;
}
const String& title() const {
  return member_title_;
}
void setTitle(const String& value);
void setTitle(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<MediaImage>> member_artwork_;
double member_start_time_{0};
String member_title_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CHAPTER_INFORMATION_INIT_H_
