// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURED_WHEEL_ACTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURED_WHEEL_ACTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CapturedWheelAction : public bindings::DictionaryBase {
  
  public:
static CapturedWheelAction* Create() {
  return MakeGarbageCollected<CapturedWheelAction>();
}
static CapturedWheelAction* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CapturedWheelAction>(isolate);
}
static CapturedWheelAction* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CapturedWheelAction();
explicit  CapturedWheelAction(v8::Isolate* isolate);

bool hasWheelDeltaX() const {
  return true;
}
int32_t wheelDeltaX() const {
  return member_wheel_delta_x_;
}
void setWheelDeltaX(int32_t value) {
  member_wheel_delta_x_ = value;
}

bool hasWheelDeltaY() const {
  return true;
}
int32_t wheelDeltaY() const {
  return member_wheel_delta_y_;
}
void setWheelDeltaY(int32_t value) {
  member_wheel_delta_y_ = value;
}

bool hasX() const {
  return true;
}
int32_t x() const {
  return member_x_;
}
void setX(int32_t value) {
  member_x_ = value;
}

bool hasY() const {
  return true;
}
int32_t y() const {
  return member_y_;
}
void setY(int32_t value) {
  member_y_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



int32_t member_wheel_delta_x_{0};
int32_t member_wheel_delta_y_{0};
int32_t member_x_{0};
int32_t member_y_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURED_WHEEL_ACTION_H_
