// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_filter_dictionary.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"blur",
"colorMatrix",
"componentTransfer",
"convolveMatrix",
};


}  // namespace 

CanvasFilterDictionary* CanvasFilterDictionary::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CanvasFilterDictionary* dictionary = MakeGarbageCollected<CanvasFilterDictionary>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CanvasFilterDictionary";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CanvasFilterDictionary::CanvasFilterDictionary() {
  
}

 CanvasFilterDictionary::CanvasFilterDictionary(v8::Isolate* isolate) {
  
}






























void CanvasFilterDictionary::Trace(Visitor* visitor) const {
  visitor->Trace(member_blur_);
visitor->Trace(member_color_matrix_);
visitor->Trace(member_component_transfer_);
visitor->Trace(member_convolve_matrix_);
bindings::DictionaryBase::Trace(visitor);
}

void CanvasFilterDictionary::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void CanvasFilterDictionary::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBlur()) {
  values[0] = ToV8Traits<IDLObject>::ToV8(script_state, member_blur_);
DCHECK(!values[0].IsEmpty());
}
if (hasColorMatrix()) {
  values[1] = ToV8Traits<IDLObject>::ToV8(script_state, member_color_matrix_);
DCHECK(!values[1].IsEmpty());
}
if (hasComponentTransfer()) {
  values[2] = ToV8Traits<IDLObject>::ToV8(script_state, member_component_transfer_);
DCHECK(!values[2].IsEmpty());
}
if (hasConvolveMatrix()) {
  values[3] = ToV8Traits<IDLObject>::ToV8(script_state, member_convolve_matrix_);
DCHECK(!values[3].IsEmpty());
}
}

const void* CanvasFilterDictionary::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> CanvasFilterDictionary::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void CanvasFilterDictionary::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CanvasFilterDictionary";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("blur");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_blur_, member_blur_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorMatrix");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_color_matrix_, member_color_matrix_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("componentTransfer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_component_transfer_, member_component_transfer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("convolveMatrix");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_convolve_matrix_, member_convolve_matrix_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CanvasFilterDictionary::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
