// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BEGIN_LAYER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BEGIN_LAYER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionObjectOrObjectArrayOrString;

class MODULES_EXPORT BeginLayerOptions : public bindings::InputDictionaryBase {
  
  public:
static BeginLayerOptions* Create() {
  return MakeGarbageCollected<BeginLayerOptions>();
}
static BeginLayerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BeginLayerOptions>(isolate);
}
static BeginLayerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BeginLayerOptions();
explicit  BeginLayerOptions(v8::Isolate* isolate);

bool hasFilter() const {
  return true;
}
V8UnionObjectOrObjectArrayOrString* filter() const {
  return member_filter_.Get();
}
void setFilter(V8UnionObjectOrObjectArrayOrString* value) {
  member_filter_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionObjectOrObjectArrayOrString> member_filter_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BEGIN_LAYER_OPTIONS_H_
