// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_LARGE_BLOB_OUTPUTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_LARGE_BLOB_OUTPUTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuthenticationExtensionsLargeBlobOutputs : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsLargeBlobOutputs* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsLargeBlobOutputs>();
}
static AuthenticationExtensionsLargeBlobOutputs* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsLargeBlobOutputs>(isolate);
}
static AuthenticationExtensionsLargeBlobOutputs* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsLargeBlobOutputs();
explicit  AuthenticationExtensionsLargeBlobOutputs(v8::Isolate* isolate);

bool hasBlob() const {
  return has_blob_;
}
DOMArrayBuffer* blob() const {
  DCHECK(hasBlob());
return member_blob_.Get();
}
DOMArrayBuffer* getBlobOr(DOMArrayBuffer* fallback_value) const {
  if (!hasBlob()) {
  return fallback_value;
}
return member_blob_.Get();
}
void setBlob(DOMArrayBuffer* value) {
  member_blob_ = value;
has_blob_ = true;
DCHECK(member_blob_);
}

bool hasSupported() const {
  return has_supported_;
}
bool supported() const {
  DCHECK(hasSupported());
return member_supported_;
}
bool getSupportedOr(bool fallback_value) const {
  if (!hasSupported()) {
  return fallback_value;
}
return member_supported_;
}
void setSupported(bool value) {
  member_supported_ = value;
has_supported_ = true;
}

bool hasWritten() const {
  return has_written_;
}
bool written() const {
  DCHECK(hasWritten());
return member_written_;
}
bool getWrittenOr(bool fallback_value) const {
  if (!hasWritten()) {
  return fallback_value;
}
return member_written_;
}
void setWritten(bool value) {
  member_written_ = value;
has_written_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_blob_ = false;
bool has_supported_ = false;
bool has_written_ = false;

Member<DOMArrayBuffer> member_blob_;
bool member_supported_;
bool member_written_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_LARGE_BLOB_OUTPUTS_H_
