// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_large_blob_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_payment_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_prf_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_supplemental_pub_keys_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cable_authentication_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_remote_desktop_client_override.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"appid",
"appidExclude",
"cableAuthentication",
"credBlob",
"credProps",
"credentialProtectionPolicy",
"enforceCredentialProtectionPolicy",
"getCredBlob",
"hmacCreateSecret",
"largeBlob",
"minPinLength",
"payment",
"prf",
"remoteDesktopClientOverride",
"supplementalPubKeys",
"uvm",
};


}  // namespace 

AuthenticationExtensionsClientInputs* AuthenticationExtensionsClientInputs::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsClientInputs* dictionary = MakeGarbageCollected<AuthenticationExtensionsClientInputs>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsClientInputs";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsClientInputs::AuthenticationExtensionsClientInputs() {
  
}

 AuthenticationExtensionsClientInputs::AuthenticationExtensionsClientInputs(v8::Isolate* isolate) {
  
}



String AuthenticationExtensionsClientInputs::getAppidOr(const String& fallback_value) const {
  if (!hasAppid()) {
  return fallback_value;
}
return member_appid_;
}

String AuthenticationExtensionsClientInputs::getAppidOr(String&& fallback_value) const {
  if (!hasAppid()) {
  return std::move(fallback_value);
}
return member_appid_;
}

void AuthenticationExtensionsClientInputs::setAppid(const String& value) {
  member_appid_ = value;
has_appid_ = true;
}

void AuthenticationExtensionsClientInputs::setAppid(String&& value) {
  member_appid_ = std::move(value);
has_appid_ = true;
}




String AuthenticationExtensionsClientInputs::getAppidExcludeOr(const String& fallback_value) const {
  if (!hasAppidExclude()) {
  return fallback_value;
}
return member_appid_exclude_;
}

String AuthenticationExtensionsClientInputs::getAppidExcludeOr(String&& fallback_value) const {
  if (!hasAppidExclude()) {
  return std::move(fallback_value);
}
return member_appid_exclude_;
}

void AuthenticationExtensionsClientInputs::setAppidExclude(const String& value) {
  member_appid_exclude_ = value;
has_appid_exclude_ = true;
}

void AuthenticationExtensionsClientInputs::setAppidExclude(String&& value) {
  member_appid_exclude_ = std::move(value);
has_appid_exclude_ = true;
}




HeapVector<Member<CableAuthenticationData>> AuthenticationExtensionsClientInputs::getCableAuthenticationOr(const HeapVector<Member<CableAuthenticationData>>& fallback_value) const {
  if (!hasCableAuthentication()) {
  return fallback_value;
}
return member_cable_authentication_;
}

HeapVector<Member<CableAuthenticationData>> AuthenticationExtensionsClientInputs::getCableAuthenticationOr(HeapVector<Member<CableAuthenticationData>>&& fallback_value) const {
  if (!hasCableAuthentication()) {
  return std::move(fallback_value);
}
return member_cable_authentication_;
}

void AuthenticationExtensionsClientInputs::setCableAuthentication(const HeapVector<Member<CableAuthenticationData>>& value) {
  member_cable_authentication_ = value;
has_cable_authentication_ = true;
}

void AuthenticationExtensionsClientInputs::setCableAuthentication(HeapVector<Member<CableAuthenticationData>>&& value) {
  member_cable_authentication_ = std::move(value);
has_cable_authentication_ = true;
}
















String AuthenticationExtensionsClientInputs::getCredentialProtectionPolicyOr(const String& fallback_value) const {
  if (!hasCredentialProtectionPolicy()) {
  return fallback_value;
}
return member_credential_protection_policy_;
}

String AuthenticationExtensionsClientInputs::getCredentialProtectionPolicyOr(String&& fallback_value) const {
  if (!hasCredentialProtectionPolicy()) {
  return std::move(fallback_value);
}
return member_credential_protection_policy_;
}

void AuthenticationExtensionsClientInputs::setCredentialProtectionPolicy(const String& value) {
  member_credential_protection_policy_ = value;
has_credential_protection_policy_ = true;
}

void AuthenticationExtensionsClientInputs::setCredentialProtectionPolicy(String&& value) {
  member_credential_protection_policy_ = std::move(value);
has_credential_protection_policy_ = true;
}







































































void AuthenticationExtensionsClientInputs::Trace(Visitor* visitor) const {
  visitor->Trace(member_cable_authentication_);
visitor->Trace(member_cred_blob_);
visitor->Trace(member_large_blob_);
visitor->Trace(member_payment_);
visitor->Trace(member_prf_);
visitor->Trace(member_remote_desktop_client_override_);
visitor->Trace(member_supplemental_pub_keys_);
bindings::DictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsClientInputs::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuthenticationExtensionsClientInputs::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAppid()) {
  values[0] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_appid_);
DCHECK(!values[0].IsEmpty());
}
if (hasAppidExclude()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_appid_exclude_);
DCHECK(!values[1].IsEmpty());
}
if (hasCableAuthentication()) {
  values[2] = ToV8Traits<IDLSequence<CableAuthenticationData>>::ToV8(script_state, member_cable_authentication_);
DCHECK(!values[2].IsEmpty());
}
if (hasCredBlob()) {
  values[3] = ToV8Traits<V8UnionArrayBufferOrArrayBufferView>::ToV8(script_state, member_cred_blob_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasCredProps()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_cred_props_);
DCHECK(!values[4].IsEmpty());
}
if (hasCredentialProtectionPolicy()) {
  values[5] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_credential_protection_policy_);
DCHECK(!values[5].IsEmpty());
}
if (hasEnforceCredentialProtectionPolicy()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_enforce_credential_protection_policy_);
DCHECK(!values[6].IsEmpty());
}
if (hasGetCredBlob()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_get_cred_blob_);
DCHECK(!values[7].IsEmpty());
}
if (hasHmacCreateSecret()) {
  values[8] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_hmac_create_secret_);
DCHECK(!values[8].IsEmpty());
}
if (hasLargeBlob()) {
  values[9] = ToV8Traits<AuthenticationExtensionsLargeBlobInputs>::ToV8(script_state, member_large_blob_.Get());
DCHECK(!values[9].IsEmpty());
}
if (hasMinPinLength()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_min_pin_length_);
DCHECK(!values[10].IsEmpty());
}
if (RuntimeEnabledFeatures::SecurePaymentConfirmationEnabled()) {
  if (hasPayment()) {
  values[11] = ToV8Traits<AuthenticationExtensionsPaymentInputs>::ToV8(script_state, member_payment_.Get());
DCHECK(!values[11].IsEmpty());
}
}
if (hasPrf()) {
  values[12] = ToV8Traits<AuthenticationExtensionsPRFInputs>::ToV8(script_state, member_prf_.Get());
DCHECK(!values[12].IsEmpty());
}
if (RuntimeEnabledFeatures::WebAuthenticationRemoteDesktopSupportEnabled()) {
  if (hasRemoteDesktopClientOverride()) {
  values[13] = ToV8Traits<RemoteDesktopClientOverride>::ToV8(script_state, member_remote_desktop_client_override_.Get());
DCHECK(!values[13].IsEmpty());
}
}
if (RuntimeEnabledFeatures::WebAuthenticationSupplementalPubKeysEnabled()) {
  if (hasSupplementalPubKeys()) {
  values[14] = ToV8Traits<AuthenticationExtensionsSupplementalPubKeysInputs>::ToV8(script_state, member_supplemental_pub_keys_.Get());
DCHECK(!values[14].IsEmpty());
}
}
if (hasUvm()) {
  values[15] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_uvm_);
DCHECK(!values[15].IsEmpty());
}
}

const void* AuthenticationExtensionsClientInputs::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuthenticationExtensionsClientInputs::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuthenticationExtensionsClientInputs::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsClientInputs";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("appid");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_appid_, member_appid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("appidExclude");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_appid_exclude_, member_appid_exclude_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("cableAuthentication");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<CableAuthenticationData>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_cable_authentication_, member_cable_authentication_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credBlob");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferOrArrayBufferView, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_cred_blob_, member_cred_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credProps");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_cred_props_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credentialProtectionPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_credential_protection_policy_, member_credential_protection_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("enforceCredentialProtectionPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_enforce_credential_protection_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("getCredBlob");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_get_cred_blob_, member_get_cred_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hmacCreateSecret");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_hmac_create_secret_, member_hmac_create_secret_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("largeBlob");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsLargeBlobInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_large_blob_, member_large_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("minPinLength");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_min_pin_length_, member_min_pin_length_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::SecurePaymentConfirmationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("payment");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsPaymentInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_payment_, member_payment_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("prf");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsPRFInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_prf_, member_prf_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebAuthenticationRemoteDesktopSupportEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("remoteDesktopClientOverride");
if (!bindings::GetDictionaryMemberFromV8Object<RemoteDesktopClientOverride, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_remote_desktop_client_override_, member_remote_desktop_client_override_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::WebAuthenticationSupplementalPubKeysEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("supplementalPubKeys");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsSupplementalPubKeysInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_supplemental_pub_keys_, member_supplemental_pub_keys_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("uvm");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_uvm_, member_uvm_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsClientInputs::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
