// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_worklet_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_port.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_user_activation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worklet_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_worklet_processor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_blink_audio_worklet_processor_constructor.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/webaudio/audio_worklet_global_scope.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8AudioWorkletGlobalScope::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsAudioWorkletGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8AudioWorkletGlobalScope::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8AudioWorkletGlobalScope::InstallInterfaceTemplate,
    nullptr,
    "AudioWorkletGlobalScope",
    V8WorkletGlobalScope::GetWrapperTypeInfo(),
    V8AudioWorkletGlobalScope::kThisTag,
    V8AudioWorkletGlobalScope::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& AudioWorkletGlobalScope::wrapper_type_info_ =
    V8AudioWorkletGlobalScope::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, AudioWorkletGlobalScope>::value,
    "AudioWorkletGlobalScope does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_audio_worklet_global_scope {


void CurrentFrameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_currentFrame_Getter");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.currentFrame.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
AudioWorkletGlobalScope* blink_receiver = V8AudioWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->currentFrame();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLongLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint64_t>());
}



void CurrentTimeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_currentTime_Getter");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.currentTime.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
AudioWorkletGlobalScope* blink_receiver = V8AudioWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->currentTime();
static_assert(bindings::IsReturnTypeCompatible<IDLDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}



void SampleRateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_sampleRate_Getter");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.sampleRate.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
AudioWorkletGlobalScope* blink_receiver = V8AudioWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->sampleRate();
static_assert(bindings::IsReturnTypeCompatible<IDLFloat, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<float>());
}



void RenderQuantumSizeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_renderQuantumSize_Getter");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.renderQuantumSize.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
AudioWorkletGlobalScope* blink_receiver = V8AudioWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->renderQuantumSize();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}


void AudioWorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_AudioWorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.AudioWorkletGlobalScope");

bindings::V8SetReturnValue(info, V8AudioWorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AudioWorkletProcessorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_AudioWorkletProcessor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.AudioWorkletProcessor");

bindings::V8SetReturnValue(info, V8AudioWorkletProcessor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_Event_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.Event");

bindings::V8SetReturnValue(info, V8Event::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_EventTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.EventTarget");

bindings::V8SetReturnValue(info, V8EventTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessageEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_MessageEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.MessageEvent");

bindings::V8SetReturnValue(info, V8MessageEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessagePortExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_MessagePort_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.MessagePort");

bindings::V8SetReturnValue(info, V8MessagePort::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void UserActivationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_UserActivation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.UserActivation");

bindings::V8SetReturnValue(info, V8UserActivation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_WorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.WorkletGlobalScope");

bindings::V8SetReturnValue(info, V8WorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RegisterProcessorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_AudioWorkletGlobalScope_registerProcessor");
BLINK_BINDINGS_TRACE_EVENT("AudioWorkletGlobalScope.registerProcessor");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kAudioWorkletGlobalScopeRegisterProcessor);

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
AudioWorkletGlobalScope* blink_receiver = V8AudioWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_processor_ctor = NativeValueTraits<V8BlinkAudioWorkletProcessorConstructor>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->registerProcessor(arg1_name, arg2_processor_ctor, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_audio_worklet_global_scope

using namespace v8_audio_worklet_global_scope;

}  // namespace 

void V8AudioWorkletGlobalScope::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8AudioWorkletGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8AudioWorkletGlobalScope::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"currentFrame", CurrentFrameAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"currentTime", CurrentTimeAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"sampleRate", SampleRateAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "AudioWorkletGlobalScope", kAttributeTable);
}




{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"AudioWorkletGlobalScope", AudioWorkletGlobalScopeExposedConstructCallback}, 
{"AudioWorkletProcessor", AudioWorkletProcessorExposedConstructCallback}, 
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"Event", EventExposedConstructCallback}, 
{"EventTarget", EventTargetExposedConstructCallback}, 
{"MessageEvent", MessageEventExposedConstructCallback}, 
{"MessagePort", MessagePortExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"UserActivation", UserActivationExposedConstructCallback}, 
{"WorkletGlobalScope", WorkletGlobalScopeExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"registerProcessor", RegisterProcessorOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "AudioWorkletGlobalScope", kOperationTable);
}



}

void V8AudioWorkletGlobalScope::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::WebAudioConfigurableRenderQuantumEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"renderQuantumSize", RenderQuantumSizeAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "AudioWorkletGlobalScope", kAttributeTable);
}



if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}



}



}  // namespace blink
