// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_PROCESSING_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_PROCESSING_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioBuffer;
class ExceptionState;

class MODULES_EXPORT AudioProcessingEventInit : public EventInit {
  
  public:
static AudioProcessingEventInit* Create() {
  return MakeGarbageCollected<AudioProcessingEventInit>();
}
static AudioProcessingEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioProcessingEventInit>(isolate);
}
static AudioProcessingEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioProcessingEventInit();
explicit  AudioProcessingEventInit(v8::Isolate* isolate);

bool hasInputBuffer() const {
  return true;
}
AudioBuffer* inputBuffer() const {
  return member_input_buffer_.Get();
}
void setInputBuffer(AudioBuffer* value) {
  member_input_buffer_ = value;
DCHECK(member_input_buffer_);
}

bool hasOutputBuffer() const {
  return true;
}
AudioBuffer* outputBuffer() const {
  return member_output_buffer_.Get();
}
void setOutputBuffer(AudioBuffer* value) {
  member_output_buffer_ = value;
DCHECK(member_output_buffer_);
}

bool hasPlaybackTime() const {
  return true;
}
double playbackTime() const {
  return member_playback_time_;
}
void setPlaybackTime(double value) {
  member_playback_time_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<AudioBuffer> member_input_buffer_;
Member<AudioBuffer> member_output_buffer_;
double member_playback_time_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_PROCESSING_EVENT_INIT_H_
