// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_ENCODER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_ENCODER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8EncodedAudioChunkOutputCallback;
class V8WebCodecsErrorCallback;

class MODULES_EXPORT AudioEncoderInit : public bindings::InputDictionaryBase {
  
  public:
static AudioEncoderInit* Create() {
  return MakeGarbageCollected<AudioEncoderInit>();
}
static AudioEncoderInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioEncoderInit>(isolate);
}
static AudioEncoderInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioEncoderInit();
explicit  AudioEncoderInit(v8::Isolate* isolate);

bool hasError() const {
  return true;
}
V8WebCodecsErrorCallback* error() const {
  return member_error_.Get();
}
void setError(V8WebCodecsErrorCallback* value) {
  member_error_ = value;
DCHECK(member_error_);
}

bool hasOutput() const {
  return true;
}
V8EncodedAudioChunkOutputCallback* output() const {
  return member_output_.Get();
}
void setOutput(V8EncodedAudioChunkOutputCallback* value) {
  member_output_ = value;
DCHECK(member_output_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8WebCodecsErrorCallback> member_error_;
Member<V8EncodedAudioChunkOutputCallback> member_output_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_ENCODER_INIT_H_
