// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DATA_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DATA_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_sample_format.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared;

class MODULES_EXPORT AudioDataInit : public bindings::InputDictionaryBase {
  
  public:
static AudioDataInit* Create() {
  return MakeGarbageCollected<AudioDataInit>();
}
static AudioDataInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioDataInit>(isolate);
}
static AudioDataInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioDataInit();
explicit  AudioDataInit(v8::Isolate* isolate);

bool hasData() const {
  return true;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* data() const {
  return member_data_.Get();
}
void setData(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  member_data_ = value;
DCHECK(member_data_);
}

bool hasFormat() const {
  return true;
}
V8AudioSampleFormat format() const {
  return member_format_;
}
void setFormat(V8AudioSampleFormat value) {
  member_format_ = value;
}
void setFormat(V8AudioSampleFormat::Enum value) {
  member_format_ = V8AudioSampleFormat(value);
}

bool hasNumberOfChannels() const {
  return true;
}
uint32_t numberOfChannels() const {
  return member_number_of_channels_;
}
void setNumberOfChannels(uint32_t value) {
  member_number_of_channels_ = value;
}

bool hasNumberOfFrames() const {
  return true;
}
uint32_t numberOfFrames() const {
  return member_number_of_frames_;
}
void setNumberOfFrames(uint32_t value) {
  member_number_of_frames_ = value;
}

bool hasSampleRate() const {
  return true;
}
float sampleRate() const {
  return member_sample_rate_;
}
void setSampleRate(float value) {
  member_sample_rate_ = value;
}

bool hasTimestamp() const {
  return true;
}
int64_t timestamp() const {
  return member_timestamp_;
}
void setTimestamp(int64_t value) {
  member_timestamp_ = value;
}

bool hasTransfer() const {
  return true;
}
const HeapVector<Member<DOMArrayBuffer>>& transfer() const {
  return member_transfer_;
}
void setTransfer(const HeapVector<Member<DOMArrayBuffer>>& value);
void setTransfer(HeapVector<Member<DOMArrayBuffer>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared> member_data_;
V8AudioSampleFormat member_format_{static_cast<V8AudioSampleFormat::Enum>(0)};
uint32_t member_number_of_channels_;
uint32_t member_number_of_frames_;
float member_sample_rate_;
int64_t member_timestamp_;
HeapVector<Member<DOMArrayBuffer>> member_transfer_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DATA_INIT_H_
