// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_CONTEXT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_CONTEXT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_context_latency_category.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_context_render_size_category.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AudioSinkOptions;
class ExceptionState;
class V8UnionAudioContextLatencyCategoryOrDouble;
class V8UnionAudioContextRenderSizeCategoryOrUnsignedLong;
class V8UnionAudioSinkOptionsOrString;

class MODULES_EXPORT AudioContextOptions : public bindings::InputDictionaryBase {
  
  public:
static AudioContextOptions* Create() {
  return MakeGarbageCollected<AudioContextOptions>();
}
static AudioContextOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioContextOptions>(isolate);
}
static AudioContextOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioContextOptions();
explicit  AudioContextOptions(v8::Isolate* isolate);

bool hasLatencyHint() const {
  return true;
}
V8UnionAudioContextLatencyCategoryOrDouble* latencyHint() const {
  return member_latency_hint_.Get();
}
void setLatencyHint(V8UnionAudioContextLatencyCategoryOrDouble* value) {
  member_latency_hint_ = value;
DCHECK(member_latency_hint_);
}

bool hasRenderSizeHint() const {
  return true;
}
V8UnionAudioContextRenderSizeCategoryOrUnsignedLong* renderSizeHint() const {
  return member_render_size_hint_.Get();
}
void setRenderSizeHint(V8UnionAudioContextRenderSizeCategoryOrUnsignedLong* value) {
  member_render_size_hint_ = value;
DCHECK(member_render_size_hint_);
}

bool hasSampleRate() const {
  return has_sample_rate_;
}
float sampleRate() const {
  DCHECK(hasSampleRate());
return member_sample_rate_;
}
float getSampleRateOr(float fallback_value) const {
  if (!hasSampleRate()) {
  return fallback_value;
}
return member_sample_rate_;
}
void setSampleRate(float value) {
  member_sample_rate_ = value;
has_sample_rate_ = true;
}

bool hasSinkId() const {
  return has_sink_id_;
}
V8UnionAudioSinkOptionsOrString* sinkId() const {
  DCHECK(hasSinkId());
return member_sink_id_.Get();
}
V8UnionAudioSinkOptionsOrString* getSinkIdOr(V8UnionAudioSinkOptionsOrString* fallback_value) const {
  if (!hasSinkId()) {
  return fallback_value;
}
return member_sink_id_.Get();
}
void setSinkId(V8UnionAudioSinkOptionsOrString* value) {
  member_sink_id_ = value;
has_sink_id_ = true;
DCHECK(member_sink_id_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_sample_rate_ = false;
bool has_sink_id_ = false;

Member<V8UnionAudioContextLatencyCategoryOrDouble> member_latency_hint_;
Member<V8UnionAudioContextRenderSizeCategoryOrUnsignedLong> member_render_size_hint_;
float member_sample_rate_;
Member<V8UnionAudioSinkOptionsOrString> member_sink_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_CONTEXT_OPTIONS_H_
