// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_ADDITIONAL_BID_SIGNATURE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_ADDITIONAL_BID_SIGNATURE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuctionAdditionalBidSignature : public bindings::DictionaryBase {
  
  public:
static AuctionAdditionalBidSignature* Create() {
  return MakeGarbageCollected<AuctionAdditionalBidSignature>();
}
static AuctionAdditionalBidSignature* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuctionAdditionalBidSignature>(isolate);
}
static AuctionAdditionalBidSignature* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuctionAdditionalBidSignature();
explicit  AuctionAdditionalBidSignature(v8::Isolate* isolate);

bool hasKey() const {
  return has_key_;
}
NotShared<DOMUint8Array> key() const {
  DCHECK(hasKey());
return member_key_;
}
NotShared<DOMUint8Array> getKeyOr(NotShared<DOMUint8Array> fallback_value) const {
  if (!hasKey()) {
  return fallback_value;
}
return member_key_;
}
void setKey(NotShared<DOMUint8Array> value) {
  member_key_ = value;
has_key_ = true;
DCHECK(member_key_);
}

bool hasSignature() const {
  return has_signature_;
}
NotShared<DOMUint8Array> signature() const {
  DCHECK(hasSignature());
return member_signature_;
}
NotShared<DOMUint8Array> getSignatureOr(NotShared<DOMUint8Array> fallback_value) const {
  if (!hasSignature()) {
  return fallback_value;
}
return member_signature_;
}
void setSignature(NotShared<DOMUint8Array> value) {
  member_signature_ = value;
has_signature_ = true;
DCHECK(member_signature_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_key_ = false;
bool has_signature_ = false;

NotShared<DOMUint8Array> member_key_;
NotShared<DOMUint8Array> member_signature_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_ADDITIONAL_BID_SIGNATURE_H_
