// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"adRenderId",
"allowedReportingOrigins",
"buyerAndSellerReportingId",
"buyerReportingId",
"creativeScanningMetadata",
"metadata",
"renderURL",
"renderUrl",
"selectableBuyerAndSellerReportingIds",
"sizeGroup",
};


}  // namespace 

AuctionAd* AuctionAd::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuctionAd* dictionary = MakeGarbageCollected<AuctionAd>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuctionAd";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuctionAd::AuctionAd() {
  
}

 AuctionAd::AuctionAd(v8::Isolate* isolate) {
  
}



String AuctionAd::getAdRenderIdOr(const String& fallback_value) const {
  if (!hasAdRenderId()) {
  return fallback_value;
}
return member_ad_render_id_;
}

String AuctionAd::getAdRenderIdOr(String&& fallback_value) const {
  if (!hasAdRenderId()) {
  return std::move(fallback_value);
}
return member_ad_render_id_;
}

void AuctionAd::setAdRenderId(const String& value) {
  member_ad_render_id_ = value;
has_ad_render_id_ = true;
}

void AuctionAd::setAdRenderId(String&& value) {
  member_ad_render_id_ = std::move(value);
has_ad_render_id_ = true;
}




Vector<String> AuctionAd::getAllowedReportingOriginsOr(const Vector<String>& fallback_value) const {
  if (!hasAllowedReportingOrigins()) {
  return fallback_value;
}
return member_allowed_reporting_origins_;
}

Vector<String> AuctionAd::getAllowedReportingOriginsOr(Vector<String>&& fallback_value) const {
  if (!hasAllowedReportingOrigins()) {
  return std::move(fallback_value);
}
return member_allowed_reporting_origins_;
}

void AuctionAd::setAllowedReportingOrigins(const Vector<String>& value) {
  member_allowed_reporting_origins_ = value;
has_allowed_reporting_origins_ = true;
}

void AuctionAd::setAllowedReportingOrigins(Vector<String>&& value) {
  member_allowed_reporting_origins_ = std::move(value);
has_allowed_reporting_origins_ = true;
}




String AuctionAd::getBuyerAndSellerReportingIdOr(const String& fallback_value) const {
  if (!hasBuyerAndSellerReportingId()) {
  return fallback_value;
}
return member_buyer_and_seller_reporting_id_;
}

String AuctionAd::getBuyerAndSellerReportingIdOr(String&& fallback_value) const {
  if (!hasBuyerAndSellerReportingId()) {
  return std::move(fallback_value);
}
return member_buyer_and_seller_reporting_id_;
}

void AuctionAd::setBuyerAndSellerReportingId(const String& value) {
  member_buyer_and_seller_reporting_id_ = value;
has_buyer_and_seller_reporting_id_ = true;
}

void AuctionAd::setBuyerAndSellerReportingId(String&& value) {
  member_buyer_and_seller_reporting_id_ = std::move(value);
has_buyer_and_seller_reporting_id_ = true;
}




String AuctionAd::getBuyerReportingIdOr(const String& fallback_value) const {
  if (!hasBuyerReportingId()) {
  return fallback_value;
}
return member_buyer_reporting_id_;
}

String AuctionAd::getBuyerReportingIdOr(String&& fallback_value) const {
  if (!hasBuyerReportingId()) {
  return std::move(fallback_value);
}
return member_buyer_reporting_id_;
}

void AuctionAd::setBuyerReportingId(const String& value) {
  member_buyer_reporting_id_ = value;
has_buyer_reporting_id_ = true;
}

void AuctionAd::setBuyerReportingId(String&& value) {
  member_buyer_reporting_id_ = std::move(value);
has_buyer_reporting_id_ = true;
}




String AuctionAd::getCreativeScanningMetadataOr(const String& fallback_value) const {
  if (!hasCreativeScanningMetadata()) {
  return fallback_value;
}
return member_creative_scanning_metadata_;
}

String AuctionAd::getCreativeScanningMetadataOr(String&& fallback_value) const {
  if (!hasCreativeScanningMetadata()) {
  return std::move(fallback_value);
}
return member_creative_scanning_metadata_;
}

void AuctionAd::setCreativeScanningMetadata(const String& value) {
  member_creative_scanning_metadata_ = value;
has_creative_scanning_metadata_ = true;
}

void AuctionAd::setCreativeScanningMetadata(String&& value) {
  member_creative_scanning_metadata_ = std::move(value);
has_creative_scanning_metadata_ = true;
}











String AuctionAd::getRenderURLOr(const String& fallback_value) const {
  if (!hasRenderURL()) {
  return fallback_value;
}
return member_render_url_;
}

String AuctionAd::getRenderURLOr(String&& fallback_value) const {
  if (!hasRenderURL()) {
  return std::move(fallback_value);
}
return member_render_url_;
}

void AuctionAd::setRenderURL(const String& value) {
  member_render_url_ = value;
has_render_url_ = true;
}

void AuctionAd::setRenderURL(String&& value) {
  member_render_url_ = std::move(value);
has_render_url_ = true;
}




String AuctionAd::getRenderUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasRenderUrlDeprecated()) {
  return fallback_value;
}
return member_render_url_deprecated_;
}

String AuctionAd::getRenderUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasRenderUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_render_url_deprecated_;
}

void AuctionAd::setRenderUrlDeprecated(const String& value) {
  member_render_url_deprecated_ = value;
has_render_url_deprecated_ = true;
}

void AuctionAd::setRenderUrlDeprecated(String&& value) {
  member_render_url_deprecated_ = std::move(value);
has_render_url_deprecated_ = true;
}




Vector<String> AuctionAd::getSelectableBuyerAndSellerReportingIdsOr(const Vector<String>& fallback_value) const {
  if (!hasSelectableBuyerAndSellerReportingIds()) {
  return fallback_value;
}
return member_selectable_buyer_and_seller_reporting_ids_;
}

Vector<String> AuctionAd::getSelectableBuyerAndSellerReportingIdsOr(Vector<String>&& fallback_value) const {
  if (!hasSelectableBuyerAndSellerReportingIds()) {
  return std::move(fallback_value);
}
return member_selectable_buyer_and_seller_reporting_ids_;
}

void AuctionAd::setSelectableBuyerAndSellerReportingIds(const Vector<String>& value) {
  member_selectable_buyer_and_seller_reporting_ids_ = value;
has_selectable_buyer_and_seller_reporting_ids_ = true;
}

void AuctionAd::setSelectableBuyerAndSellerReportingIds(Vector<String>&& value) {
  member_selectable_buyer_and_seller_reporting_ids_ = std::move(value);
has_selectable_buyer_and_seller_reporting_ids_ = true;
}




String AuctionAd::getSizeGroupOr(const String& fallback_value) const {
  if (!hasSizeGroup()) {
  return fallback_value;
}
return member_size_group_;
}

String AuctionAd::getSizeGroupOr(String&& fallback_value) const {
  if (!hasSizeGroup()) {
  return std::move(fallback_value);
}
return member_size_group_;
}

void AuctionAd::setSizeGroup(const String& value) {
  member_size_group_ = value;
has_size_group_ = true;
}

void AuctionAd::setSizeGroup(String&& value) {
  member_size_group_ = std::move(value);
has_size_group_ = true;
}



void AuctionAd::Trace(Visitor* visitor) const {
  visitor->Trace(member_metadata_);
bindings::DictionaryBase::Trace(visitor);
}

void AuctionAd::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuctionAd::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAdRenderId()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_ad_render_id_);
DCHECK(!values[0].IsEmpty());
}
if (hasAllowedReportingOrigins()) {
  values[1] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_allowed_reporting_origins_);
DCHECK(!values[1].IsEmpty());
}
if (hasBuyerAndSellerReportingId()) {
  values[2] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_buyer_and_seller_reporting_id_);
DCHECK(!values[2].IsEmpty());
}
if (hasBuyerReportingId()) {
  values[3] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_buyer_reporting_id_);
DCHECK(!values[3].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv1CreativeScanningEnabled()) {
  if (hasCreativeScanningMetadata()) {
  values[4] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_creative_scanning_metadata_);
DCHECK(!values[4].IsEmpty());
}
}
if (hasMetadata()) {
  values[5] = ToV8Traits<IDLAny>::ToV8(script_state, member_metadata_);
DCHECK(!values[5].IsEmpty());
}
if (hasRenderURL()) {
  values[6] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_render_url_);
DCHECK(!values[6].IsEmpty());
}
if (hasRenderUrlDeprecated()) {
  values[7] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_render_url_deprecated_);
DCHECK(!values[7].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeAuctionDealSupportEnabled()) {
  if (hasSelectableBuyerAndSellerReportingIds()) {
  values[8] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_selectable_buyer_and_seller_reporting_ids_);
DCHECK(!values[8].IsEmpty());
}
}
if (hasSizeGroup()) {
  values[9] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_size_group_);
DCHECK(!values[9].IsEmpty());
}
}

const void* AuctionAd::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuctionAd::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuctionAd::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuctionAd";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("adRenderId");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_ad_render_id_, member_ad_render_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("allowedReportingOrigins");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_allowed_reporting_origins_, member_allowed_reporting_origins_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("buyerAndSellerReportingId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_buyer_and_seller_reporting_id_, member_buyer_and_seller_reporting_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("buyerReportingId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_buyer_reporting_id_, member_buyer_reporting_id_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv1CreativeScanningEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("creativeScanningMetadata");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_creative_scanning_metadata_, member_creative_scanning_metadata_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("metadata");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_metadata_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("renderURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_render_url_, member_render_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("renderUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_render_url_deprecated_, member_render_url_deprecated_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeAuctionDealSupportEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("selectableBuyerAndSellerReportingIds");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_selectable_buyer_and_seller_reporting_ids_, member_selectable_buyer_and_seller_reporting_ids_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sizeGroup");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_size_group_, member_size_group_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuctionAd::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
