// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_PROPERTIES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_PROPERTIES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AdProperties : public bindings::InputDictionaryBase {
  
  public:
static AdProperties* Create() {
  return MakeGarbageCollected<AdProperties>();
}
static AdProperties* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdProperties>(isolate);
}
static AdProperties* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdProperties();
explicit  AdProperties(v8::Isolate* isolate);

bool hasAdtype() const {
  return has_adtype_;
}
const String& adtype() const {
  DCHECK(hasAdtype());
return member_adtype_;
}
String getAdtypeOr(const String& fallback_value) const;
String getAdtypeOr(String&& fallback_value) const;
void setAdtype(const String& value);
void setAdtype(String&& value);

bool hasBidFloor() const {
  return has_bid_floor_;
}
double bidFloor() const {
  DCHECK(hasBidFloor());
return member_bid_floor_;
}
double getBidFloorOr(double fallback_value) const {
  if (!hasBidFloor()) {
  return fallback_value;
}
return member_bid_floor_;
}
void setBidFloor(double value) {
  member_bid_floor_ = value;
has_bid_floor_ = true;
}

bool hasHeight() const {
  return has_height_;
}
const String& height() const {
  DCHECK(hasHeight());
return member_height_;
}
String getHeightOr(const String& fallback_value) const;
String getHeightOr(String&& fallback_value) const;
void setHeight(const String& value);
void setHeight(String&& value);

bool hasLang() const {
  return has_lang_;
}
const String& lang() const {
  DCHECK(hasLang());
return member_lang_;
}
String getLangOr(const String& fallback_value) const;
String getLangOr(String&& fallback_value) const;
void setLang(const String& value);
void setLang(String&& value);

bool hasSlot() const {
  return has_slot_;
}
const String& slot() const {
  DCHECK(hasSlot());
return member_slot_;
}
String getSlotOr(const String& fallback_value) const;
String getSlotOr(String&& fallback_value) const;
void setSlot(const String& value);
void setSlot(String&& value);

bool hasWidth() const {
  return has_width_;
}
const String& width() const {
  DCHECK(hasWidth());
return member_width_;
}
String getWidthOr(const String& fallback_value) const;
String getWidthOr(String&& fallback_value) const;
void setWidth(const String& value);
void setWidth(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_adtype_ = false;
bool has_bid_floor_ = false;
bool has_height_ = false;
bool has_lang_ = false;
bool has_slot_ = false;
bool has_width_ = false;

String member_adtype_;
double member_bid_floor_;
String member_height_;
String member_lang_;
String member_slot_;
String member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_PROPERTIES_H_
