// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_data_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_data_buyer_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_one_seller.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"coordinatorOrigin",
"perBuyerConfig",
"requestSize",
"seller",
"sellers",
};


}  // namespace 

AdAuctionDataConfig* AdAuctionDataConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AdAuctionDataConfig* dictionary = MakeGarbageCollected<AdAuctionDataConfig>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AdAuctionDataConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AdAuctionDataConfig::AdAuctionDataConfig() {
  
}

 AdAuctionDataConfig::AdAuctionDataConfig(v8::Isolate* isolate) {
  
}



String AdAuctionDataConfig::getCoordinatorOriginOr(const String& fallback_value) const {
  if (!hasCoordinatorOrigin()) {
  return fallback_value;
}
return member_coordinator_origin_;
}

String AdAuctionDataConfig::getCoordinatorOriginOr(String&& fallback_value) const {
  if (!hasCoordinatorOrigin()) {
  return std::move(fallback_value);
}
return member_coordinator_origin_;
}

void AdAuctionDataConfig::setCoordinatorOrigin(const String& value) {
  member_coordinator_origin_ = value;
has_coordinator_origin_ = true;
}

void AdAuctionDataConfig::setCoordinatorOrigin(String&& value) {
  member_coordinator_origin_ = std::move(value);
has_coordinator_origin_ = true;
}




HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>> AdAuctionDataConfig::getPerBuyerConfigOr(const HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>& fallback_value) const {
  if (!hasPerBuyerConfig()) {
  return fallback_value;
}
return member_per_buyer_config_;
}

HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>> AdAuctionDataConfig::getPerBuyerConfigOr(HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>&& fallback_value) const {
  if (!hasPerBuyerConfig()) {
  return std::move(fallback_value);
}
return member_per_buyer_config_;
}

void AdAuctionDataConfig::setPerBuyerConfig(const HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>& value) {
  member_per_buyer_config_ = value;
has_per_buyer_config_ = true;
}

void AdAuctionDataConfig::setPerBuyerConfig(HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>&& value) {
  member_per_buyer_config_ = std::move(value);
has_per_buyer_config_ = true;
}











String AdAuctionDataConfig::getSellerOr(const String& fallback_value) const {
  if (!hasSeller()) {
  return fallback_value;
}
return member_seller_;
}

String AdAuctionDataConfig::getSellerOr(String&& fallback_value) const {
  if (!hasSeller()) {
  return std::move(fallback_value);
}
return member_seller_;
}

void AdAuctionDataConfig::setSeller(const String& value) {
  member_seller_ = value;
has_seller_ = true;
}

void AdAuctionDataConfig::setSeller(String&& value) {
  member_seller_ = std::move(value);
has_seller_ = true;
}




HeapVector<Member<AdAuctionOneSeller>> AdAuctionDataConfig::getSellersOr(const HeapVector<Member<AdAuctionOneSeller>>& fallback_value) const {
  if (!hasSellers()) {
  return fallback_value;
}
return member_sellers_;
}

HeapVector<Member<AdAuctionOneSeller>> AdAuctionDataConfig::getSellersOr(HeapVector<Member<AdAuctionOneSeller>>&& fallback_value) const {
  if (!hasSellers()) {
  return std::move(fallback_value);
}
return member_sellers_;
}

void AdAuctionDataConfig::setSellers(const HeapVector<Member<AdAuctionOneSeller>>& value) {
  member_sellers_ = value;
has_sellers_ = true;
}

void AdAuctionDataConfig::setSellers(HeapVector<Member<AdAuctionOneSeller>>&& value) {
  member_sellers_ = std::move(value);
has_sellers_ = true;
}



void AdAuctionDataConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_per_buyer_config_);
visitor->Trace(member_sellers_);
bindings::InputDictionaryBase::Trace(visitor);
}

void AdAuctionDataConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AdAuctionDataConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("coordinatorOrigin");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_coordinator_origin_, member_coordinator_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerConfig");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, AdAuctionDataBuyerConfig>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_per_buyer_config_, member_per_buyer_config_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestSize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_request_size_, member_request_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("seller");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_seller_, member_seller_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeBiddingAndAuctionServerAPIMultiSellerEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("sellers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AdAuctionOneSeller>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_sellers_, member_sellers_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> AdAuctionDataConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
