// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_window_properties.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/frame/window_properties.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8WindowProperties::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WindowProperties::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WindowProperties::InstallInterfaceTemplate,
    V8WindowProperties::InstallContextDependentProperties,
    "WindowProperties",
    V8EventTarget::GetWrapperTypeInfo(),
    V8WindowProperties::kThisTag,
    V8WindowProperties::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    true,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WindowProperties::wrapper_type_info_ =
    V8WindowProperties::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WindowProperties>::value,
    "WindowProperties inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

v8::Intercepted V8WindowProperties::NamedPropertyGetterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_NamedPropertyGetter");

// 3.7.4.1. [[GetOwnProperty]]
// https://webidl.spec.whatwg.org/#named-properties-object-getownproperty
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
WindowProperties* blink_receiver = V8WindowProperties::ToWrappableUnsafe(isolate, v8_receiver);

// Fast path for when the receiver doesn't have any named properties, possibly
// avoiding any parameter conversions.
if (!bindings::HasAnyNamedProperties(blink_receiver)) {    return v8::Intercepted::kNo;}
// "If the result of running the named property visibility
//  algorithm with property name P and object O is true, then:"
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
auto&& return_value = blink_receiver->AnonymousNamedGetter(blink_property_name);
static_assert(bindings::IsReturnTypeCompatible<IDLObject, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (return_value.IsEmpty()) {
  // "Return OrdinaryGetOwnProperty(O, P)."
return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
bindings::V8SetReturnValue(info, return_value);
return v8::Intercepted::kYes;
}

v8::Intercepted V8WindowProperties::NamedPropertySetterCallback(v8::Local<v8::Name> v8_property_name, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_NamedPropertySetter");

// 3.7.4.2. [[DefineOwnProperty]]
// https://webidl.spec.whatwg.org/#named-properties-object-defineownproperty
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Named property setter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8WindowProperties::NamedPropertyDeleterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_NamedPropertyDeleter");

// 3.7.4.3. [[Delete]]
// https://webidl.spec.whatwg.org/#named-properties-object-delete
bindings::V8SetReturnValue(info, false);
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Named property deleter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8WindowProperties::NamedPropertyDefinerCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_NamedPropertyDefiner");

// 3.7.4.2. [[DefineOwnProperty]]
// https://webidl.spec.whatwg.org/#named-properties-object-defineownproperty 
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Named property setter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8WindowProperties::NamedPropertyDescriptorCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_NamedPropertyDescriptor");

// 3.7.4.1. [[GetOwnProperty]]
// https://webidl.spec.whatwg.org/#named-properties-object-getownproperty

// "If the result of running the named property visibility algorithm with
//  property name P and object O is true, then:"
v8::Local<v8::Object> v8_receiver = info.HolderV2();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
if (v8_receiver->GetRealNamedPropertyAttributesInPrototypeChain(
        current_context, v8_property_name).IsJust()) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
auto intercepted =
    V8WindowProperties::NamedPropertyGetterCallback(v8_property_name, info);
// "Return OrdinaryGetOwnProperty(O, P)."
if (intercepted == v8::Intercepted::kNo) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "Let desc be a newly created Property Descriptor with no fields."
// "Set desc.[[Value]] to the result of converting value to an ECMAScript
//  value."
// "If O implements an interface with a named property setter, then set
//  desc.[[Writable]] to true, otherwise set it to false."
// "If O implements an interface with the [LegacyUnenumerableNamedProperties]
//  extended attribute, then set desc.[[Enumerable]] to false, otherwise set
//  it to true."
// "Set desc.[[Configurable]] to true."
// "Return desc."
v8::Local<v8::Value> v8_value = info.GetReturnValue().Get();
v8::PropertyDescriptor desc(v8_value, /*writable=*/true);
desc.set_enumerable(false);
desc.set_configurable(true);
bindings::V8SetReturnValue(info, desc);
return v8::Intercepted::kYes;

}

v8::Intercepted V8WindowProperties::IndexedPropertyGetterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_IndexedPropertyGetter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8WindowProperties::NamedPropertyGetterCallback(
    V8AtomicString(isolate, blink_property_index), info);

}

v8::Intercepted V8WindowProperties::IndexedPropertySetterCallback(uint32_t index, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_IndexedPropertySetter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8WindowProperties::NamedPropertySetterCallback(
    V8AtomicString(isolate, blink_property_index), v8_property_value,
    info);

}

v8::Intercepted V8WindowProperties::IndexedPropertyDeleterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_IndexedPropertyDeleter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8WindowProperties::NamedPropertyDeleterCallback(
    V8AtomicString(isolate, blink_property_index), info);

}

v8::Intercepted V8WindowProperties::IndexedPropertyDefinerCallback(uint32_t index, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_IndexedPropertyDefiner");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8WindowProperties::NamedPropertyDefinerCallback(
    V8AtomicString(isolate, blink_property_index), v8_property_desc,
    info);

}

v8::Intercepted V8WindowProperties::IndexedPropertyDescriptorCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WindowProperties_IndexedPropertyDescriptor");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8WindowProperties::NamedPropertyDescriptorCallback(
    V8AtomicString(isolate, blink_property_index), info);

}


namespace  {

namespace v8_window_properties {



}  // namespace v8_window_properties

using namespace v8_window_properties;

}  // namespace 

void V8WindowProperties::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WindowProperties::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);



// Named interceptors
prototype_template->SetHandler(
    v8::NamedPropertyHandlerConfiguration(
        V8WindowProperties::NamedPropertyGetterCallback,
        V8WindowProperties::NamedPropertySetterCallback,
        nullptr,  // query
        V8WindowProperties::NamedPropertyDeleterCallback,
        nullptr,  // enumerator
        V8WindowProperties::NamedPropertyDefinerCallback,
        V8WindowProperties::NamedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        static_cast<v8::PropertyHandlerFlags>(int32_t(v8::PropertyHandlerFlags::kOnlyInterceptStrings) | int32_t(v8::PropertyHandlerFlags::kNonMasking) | int32_t(v8::PropertyHandlerFlags::kHasNoSideEffect))));
// Indexed interceptors
prototype_template->SetHandler(
    v8::IndexedPropertyHandlerConfiguration(
        V8WindowProperties::IndexedPropertyGetterCallback,
        V8WindowProperties::IndexedPropertySetterCallback,
        nullptr,  // query
        V8WindowProperties::IndexedPropertyDeleterCallback,
        nullptr,  // enumerator
        V8WindowProperties::IndexedPropertyDefinerCallback,
        V8WindowProperties::IndexedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        v8::PropertyHandlerFlags::kNone));


// [Global] - prototype object in the prototype chain of global objects
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
prototype_template->SetImmutableProto();

}



void V8WindowProperties::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}

namespace bindings {

namespace v8_context_snapshot {

base::span<const intptr_t> GetRefTableOfV8WindowProperties() {
  static const intptr_t kReferenceTable[] = {
reinterpret_cast<intptr_t>(V8WindowProperties::GetWrapperTypeInfo()),
reinterpret_cast<intptr_t>(V8WindowProperties::NamedPropertyGetterCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::NamedPropertySetterCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::NamedPropertyDeleterCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::NamedPropertyDefinerCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::NamedPropertyDescriptorCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::IndexedPropertyGetterCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::IndexedPropertySetterCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::IndexedPropertyDeleterCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::IndexedPropertyDefinerCallback),
reinterpret_cast<intptr_t>(V8WindowProperties::IndexedPropertyDescriptorCallback),
};
return kReferenceTable;
}

void InstallPropsOfV8WindowProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;







}

void InstallPropsOfV8WindowProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  
}


}  // namespace v8_context_snapshot

}  // namespace bindings


}  // namespace blink
