// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WINDOW_POST_MESSAGE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WINDOW_POST_MESSAGE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_post_message_options.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT WindowPostMessageOptions : public PostMessageOptions {
  
  public:
static WindowPostMessageOptions* Create() {
  return MakeGarbageCollected<WindowPostMessageOptions>();
}
static WindowPostMessageOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WindowPostMessageOptions>(isolate);
}
static WindowPostMessageOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WindowPostMessageOptions();
explicit  WindowPostMessageOptions(v8::Isolate* isolate);

bool hasDelegate() const {
  return has_delegate_;
}
const String& delegate() const {
  DCHECK(hasDelegate());
return member_delegate_;
}
String getDelegateOr(const String& fallback_value) const;
String getDelegateOr(String&& fallback_value) const;
void setDelegate(const String& value);
void setDelegate(String&& value);

bool hasTargetOrigin() const {
  return true;
}
const String& targetOrigin() const {
  return member_target_origin_;
}
void setTargetOrigin(const String& value);
void setTargetOrigin(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = PostMessageOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_delegate_ = false;

String member_delegate_;
String member_target_origin_{"/"};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WINDOW_POST_MESSAGE_OPTIONS_H_
