// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VALIDITY_STATE_FLAGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VALIDITY_STATE_FLAGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ValidityStateFlags : public bindings::InputDictionaryBase {
  
  public:
static ValidityStateFlags* Create() {
  return MakeGarbageCollected<ValidityStateFlags>();
}
static ValidityStateFlags* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ValidityStateFlags>(isolate);
}
static ValidityStateFlags* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ValidityStateFlags();
explicit  ValidityStateFlags(v8::Isolate* isolate);

bool hasBadInput() const {
  return true;
}
bool badInput() const {
  return member_bad_input_;
}
void setBadInput(bool value) {
  member_bad_input_ = value;
}

bool hasCustomError() const {
  return true;
}
bool customError() const {
  return member_custom_error_;
}
void setCustomError(bool value) {
  member_custom_error_ = value;
}

bool hasPatternMismatch() const {
  return true;
}
bool patternMismatch() const {
  return member_pattern_mismatch_;
}
void setPatternMismatch(bool value) {
  member_pattern_mismatch_ = value;
}

bool hasRangeOverflow() const {
  return true;
}
bool rangeOverflow() const {
  return member_range_overflow_;
}
void setRangeOverflow(bool value) {
  member_range_overflow_ = value;
}

bool hasRangeUnderflow() const {
  return true;
}
bool rangeUnderflow() const {
  return member_range_underflow_;
}
void setRangeUnderflow(bool value) {
  member_range_underflow_ = value;
}

bool hasStepMismatch() const {
  return true;
}
bool stepMismatch() const {
  return member_step_mismatch_;
}
void setStepMismatch(bool value) {
  member_step_mismatch_ = value;
}

bool hasTooLong() const {
  return true;
}
bool tooLong() const {
  return member_too_long_;
}
void setTooLong(bool value) {
  member_too_long_ = value;
}

bool hasTooShort() const {
  return true;
}
bool tooShort() const {
  return member_too_short_;
}
void setTooShort(bool value) {
  member_too_short_ = value;
}

bool hasTypeMismatch() const {
  return true;
}
bool typeMismatch() const {
  return member_type_mismatch_;
}
void setTypeMismatch(bool value) {
  member_type_mismatch_ = value;
}

bool hasValueMissing() const {
  return true;
}
bool valueMissing() const {
  return member_value_missing_;
}
void setValueMissing(bool value) {
  member_value_missing_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_bad_input_{false};
bool member_custom_error_{false};
bool member_pattern_mismatch_{false};
bool member_range_overflow_{false};
bool member_range_underflow_{false};
bool member_step_mismatch_{false};
bool member_too_long_{false};
bool member_too_short_{false};
bool member_type_mismatch_{false};
bool member_value_missing_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VALIDITY_STATE_FLAGS_H_
