// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_URL_PATTERN_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_URL_PATTERN_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class URLPatternComponentResult;
class URLPatternInit;
class V8UnionURLPatternInitOrUSVString;

class CORE_EXPORT URLPatternResult : public bindings::DictionaryBase {
  
  public:
static URLPatternResult* Create() {
  return MakeGarbageCollected<URLPatternResult>();
}
static URLPatternResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<URLPatternResult>(isolate);
}
static URLPatternResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  URLPatternResult();
explicit  URLPatternResult(v8::Isolate* isolate);

bool hasHash() const {
  return has_hash_;
}
URLPatternComponentResult* hash() const {
  DCHECK(hasHash());
return member_hash_.Get();
}
URLPatternComponentResult* getHashOr(URLPatternComponentResult* fallback_value) const {
  if (!hasHash()) {
  return fallback_value;
}
return member_hash_.Get();
}
void setHash(URLPatternComponentResult* value) {
  member_hash_ = value;
has_hash_ = true;
DCHECK(member_hash_);
}

bool hasHostname() const {
  return has_hostname_;
}
URLPatternComponentResult* hostname() const {
  DCHECK(hasHostname());
return member_hostname_.Get();
}
URLPatternComponentResult* getHostnameOr(URLPatternComponentResult* fallback_value) const {
  if (!hasHostname()) {
  return fallback_value;
}
return member_hostname_.Get();
}
void setHostname(URLPatternComponentResult* value) {
  member_hostname_ = value;
has_hostname_ = true;
DCHECK(member_hostname_);
}

bool hasInputs() const {
  return has_inputs_;
}
const HeapVector<Member<V8UnionURLPatternInitOrUSVString>>& inputs() const {
  DCHECK(hasInputs());
return member_inputs_;
}
HeapVector<Member<V8UnionURLPatternInitOrUSVString>> getInputsOr(const HeapVector<Member<V8UnionURLPatternInitOrUSVString>>& fallback_value) const;
HeapVector<Member<V8UnionURLPatternInitOrUSVString>> getInputsOr(HeapVector<Member<V8UnionURLPatternInitOrUSVString>>&& fallback_value) const;
void setInputs(const HeapVector<Member<V8UnionURLPatternInitOrUSVString>>& value);
void setInputs(HeapVector<Member<V8UnionURLPatternInitOrUSVString>>&& value);

bool hasPassword() const {
  return has_password_;
}
URLPatternComponentResult* password() const {
  DCHECK(hasPassword());
return member_password_.Get();
}
URLPatternComponentResult* getPasswordOr(URLPatternComponentResult* fallback_value) const {
  if (!hasPassword()) {
  return fallback_value;
}
return member_password_.Get();
}
void setPassword(URLPatternComponentResult* value) {
  member_password_ = value;
has_password_ = true;
DCHECK(member_password_);
}

bool hasPathname() const {
  return has_pathname_;
}
URLPatternComponentResult* pathname() const {
  DCHECK(hasPathname());
return member_pathname_.Get();
}
URLPatternComponentResult* getPathnameOr(URLPatternComponentResult* fallback_value) const {
  if (!hasPathname()) {
  return fallback_value;
}
return member_pathname_.Get();
}
void setPathname(URLPatternComponentResult* value) {
  member_pathname_ = value;
has_pathname_ = true;
DCHECK(member_pathname_);
}

bool hasPort() const {
  return has_port_;
}
URLPatternComponentResult* port() const {
  DCHECK(hasPort());
return member_port_.Get();
}
URLPatternComponentResult* getPortOr(URLPatternComponentResult* fallback_value) const {
  if (!hasPort()) {
  return fallback_value;
}
return member_port_.Get();
}
void setPort(URLPatternComponentResult* value) {
  member_port_ = value;
has_port_ = true;
DCHECK(member_port_);
}

bool hasProtocol() const {
  return has_protocol_;
}
URLPatternComponentResult* protocol() const {
  DCHECK(hasProtocol());
return member_protocol_.Get();
}
URLPatternComponentResult* getProtocolOr(URLPatternComponentResult* fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_.Get();
}
void setProtocol(URLPatternComponentResult* value) {
  member_protocol_ = value;
has_protocol_ = true;
DCHECK(member_protocol_);
}

bool hasSearch() const {
  return has_search_;
}
URLPatternComponentResult* search() const {
  DCHECK(hasSearch());
return member_search_.Get();
}
URLPatternComponentResult* getSearchOr(URLPatternComponentResult* fallback_value) const {
  if (!hasSearch()) {
  return fallback_value;
}
return member_search_.Get();
}
void setSearch(URLPatternComponentResult* value) {
  member_search_ = value;
has_search_ = true;
DCHECK(member_search_);
}

bool hasUsername() const {
  return has_username_;
}
URLPatternComponentResult* username() const {
  DCHECK(hasUsername());
return member_username_.Get();
}
URLPatternComponentResult* getUsernameOr(URLPatternComponentResult* fallback_value) const {
  if (!hasUsername()) {
  return fallback_value;
}
return member_username_.Get();
}
void setUsername(URLPatternComponentResult* value) {
  member_username_ = value;
has_username_ = true;
DCHECK(member_username_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_hash_ = false;
bool has_hostname_ = false;
bool has_inputs_ = false;
bool has_password_ = false;
bool has_pathname_ = false;
bool has_port_ = false;
bool has_protocol_ = false;
bool has_search_ = false;
bool has_username_ = false;

Member<URLPatternComponentResult> member_hash_;
Member<URLPatternComponentResult> member_hostname_;
HeapVector<Member<V8UnionURLPatternInitOrUSVString>> member_inputs_;
Member<URLPatternComponentResult> member_password_;
Member<URLPatternComponentResult> member_pathname_;
Member<URLPatternComponentResult> member_port_;
Member<URLPatternComponentResult> member_protocol_;
Member<URLPatternComponentResult> member_search_;
Member<URLPatternComponentResult> member_username_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_URL_PATTERN_RESULT_H_
