// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_URL_PATTERN_COMPONENT_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_URL_PATTERN_COMPONENT_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT URLPatternComponentResult : public bindings::DictionaryBase {
  
  public:
static URLPatternComponentResult* Create() {
  return MakeGarbageCollected<URLPatternComponentResult>();
}
static URLPatternComponentResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<URLPatternComponentResult>(isolate);
}
static URLPatternComponentResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  URLPatternComponentResult();
explicit  URLPatternComponentResult(v8::Isolate* isolate);

bool hasGroups() const {
  return has_groups_;
}
const HeapVector<std::pair<String, ScriptValue>>& groups() const {
  DCHECK(hasGroups());
return member_groups_;
}
HeapVector<std::pair<String, ScriptValue>> getGroupsOr(const HeapVector<std::pair<String, ScriptValue>>& fallback_value) const;
HeapVector<std::pair<String, ScriptValue>> getGroupsOr(HeapVector<std::pair<String, ScriptValue>>&& fallback_value) const;
void setGroups(const HeapVector<std::pair<String, ScriptValue>>& value);
void setGroups(HeapVector<std::pair<String, ScriptValue>>&& value);

bool hasInput() const {
  return has_input_;
}
const String& input() const {
  DCHECK(hasInput());
return member_input_;
}
String getInputOr(const String& fallback_value) const;
String getInputOr(String&& fallback_value) const;
void setInput(const String& value);
void setInput(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_groups_ = false;
bool has_input_ = false;

HeapVector<std::pair<String, ScriptValue>> member_groups_;
String member_input_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_URL_PATTERN_COMPONENT_RESULT_H_
