// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_USVSTRING_USVSTRINGSEQUENCESEQUENCE_USVSTRINGUSVSTRINGRECORD_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_USVSTRING_USVSTRINGSEQUENCESEQUENCE_USVSTRINGUSVSTRINGRECORD_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kUSVString, kUSVStringSequenceSequence, kUSVStringUSVStringRecord
};

static V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord(const String& value);
explicit  V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord(String&& value);
explicit  V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord(const Vector<Vector<String>>& value);
explicit  V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord(Vector<Vector<String>>&& value);
explicit  V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord(const Vector<std::pair<String, String>>& value);
explicit  V8UnionUSVStringOrUSVStringSequenceSequenceOrUSVStringUSVStringRecord(Vector<std::pair<String, String>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsUSVString() const {
  return content_type_ == ContentType::kUSVString;
}
const String& GetAsUSVString() const {
  DCHECK_EQ(content_type_, ContentType::kUSVString);
return member_usv_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsUSVStringSequenceSequence() const {
  return content_type_ == ContentType::kUSVStringSequenceSequence;
}
const Vector<Vector<String>>& GetAsUSVStringSequenceSequence() const {
  DCHECK_EQ(content_type_, ContentType::kUSVStringSequenceSequence);
return member_usv_string_sequence_sequence_;
}
void Set(const Vector<Vector<String>>& value);
void Set(Vector<Vector<String>>&& value);

bool IsUSVStringUSVStringRecord() const {
  return content_type_ == ContentType::kUSVStringUSVStringRecord;
}
const Vector<std::pair<String, String>>& GetAsUSVStringUSVStringRecord() const {
  DCHECK_EQ(content_type_, ContentType::kUSVStringUSVStringRecord);
return member_usv_string_usv_string_record_;
}
void Set(const Vector<std::pair<String, String>>& value);
void Set(Vector<std::pair<String, String>>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(USVString or record<USVString, USVString> or sequence<sequence<USVString>>)";
}

ContentType content_type_;

String member_usv_string_;
Vector<Vector<String>> member_usv_string_sequence_sequence_;
Vector<std::pair<String, String>> member_usv_string_usv_string_record_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_USVSTRING_USVSTRINGSEQUENCESEQUENCE_USVSTRINGUSVSTRINGRECORD_H_
