// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_urlpatterninit_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_init.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionURLPatternInitOrUSVString* V8UnionURLPatternInitOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = URLPatternInit::Create(isolate);
return MakeGarbageCollected<V8UnionURLPatternInitOrUSVString>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<URLPatternInit>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionURLPatternInitOrUSVString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionURLPatternInitOrUSVString>(std::move(blink_value));
}
}

 V8UnionURLPatternInitOrUSVString::V8UnionURLPatternInitOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionURLPatternInitOrUSVString::V8UnionURLPatternInitOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}







void V8UnionURLPatternInitOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionURLPatternInitOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


v8::Local<v8::Value> V8UnionURLPatternInitOrUSVString::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kURLPatternInit: {
    return ToV8Traits<URLPatternInit>::ToV8(script_state, member_url_pattern_init_.Get());
  }
  case ContentType::kUSVString: {
    return ToV8Traits<IDLUSVString>::ToV8(script_state, member_usv_string_);
  }
}

NOTREACHED();
}

void V8UnionURLPatternInitOrUSVString::Trace(Visitor* visitor) const {
  visitor->Trace(member_url_pattern_init_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionURLPatternInitOrUSVString::Clear() {
  member_url_pattern_init_.Clear();
member_usv_string_ = String();
}



}  // namespace blink
