// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_unsignedlong.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionStringOrUnsignedLong* V8UnionStringOrUnsignedLong::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLUnsignedLong>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrUnsignedLong>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrUnsignedLong>(std::move(blink_value));
}
}

 V8UnionStringOrUnsignedLong::V8UnionStringOrUnsignedLong(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionStringOrUnsignedLong::V8UnionStringOrUnsignedLong(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}




void V8UnionStringOrUnsignedLong::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionStringOrUnsignedLong::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}





v8::Local<v8::Value> V8UnionStringOrUnsignedLong::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kUnsignedLong: {
    return ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_unsigned_long_);
  }
}

NOTREACHED();
}

void V8UnionStringOrUnsignedLong::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionStringOrUnsignedLong::Clear() {
  member_string_ = String();
member_unsigned_long_ = 0;
}



}  // namespace blink
