// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_SANITIZER_SANITIZERCONFIG_SANITIZERPRESETS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_SANITIZER_SANITIZERCONFIG_SANITIZERPRESETS_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_presets.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Sanitizer;
class SanitizerConfig;
class ScriptState;
class V8UnionSanitizerConfigOrSanitizerPresets;

class CORE_EXPORT V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kSanitizer, kSanitizerConfig, kSanitizerPresets
};

static V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets(Sanitizer* value) : content_type_(ContentType::kSanitizer), member_sanitizer_(value) {
  DCHECK(value);
}
explicit  V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets(SanitizerConfig* value) : content_type_(ContentType::kSanitizerConfig), member_sanitizer_config_(value) {
  DCHECK(value);
}
explicit  V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets(V8SanitizerPresets value) : content_type_(ContentType::kSanitizerPresets), member_sanitizer_presets_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsSanitizer() const {
  return content_type_ == ContentType::kSanitizer;
}
Sanitizer* GetAsSanitizer() const {
  DCHECK_EQ(content_type_, ContentType::kSanitizer);
return member_sanitizer_.Get();
}
void Set(Sanitizer* value) {
  DCHECK(value);
Clear();
member_sanitizer_ = value;
content_type_ = ContentType::kSanitizer;
}

bool IsSanitizerConfig() const {
  return content_type_ == ContentType::kSanitizerConfig;
}
SanitizerConfig* GetAsSanitizerConfig() const {
  DCHECK_EQ(content_type_, ContentType::kSanitizerConfig);
return member_sanitizer_config_.Get();
}
void Set(SanitizerConfig* value) {
  DCHECK(value);
Clear();
member_sanitizer_config_ = value;
content_type_ = ContentType::kSanitizerConfig;
}

bool IsSanitizerPresets() const {
  return content_type_ == ContentType::kSanitizerPresets;
}
V8SanitizerPresets GetAsSanitizerPresets() const {
  DCHECK_EQ(content_type_, ContentType::kSanitizerPresets);
return member_sanitizer_presets_;
}
void Set(V8SanitizerPresets value) {
  Clear();
member_sanitizer_presets_ = value;
content_type_ = ContentType::kSanitizerPresets;
}

bool IsV8UnionSanitizerConfigOrSanitizerPresets() const {
  return content_type_ == ContentType::kSanitizerConfig || content_type_ == ContentType::kSanitizerPresets;
}
V8UnionSanitizerConfigOrSanitizerPresets* GetAsV8UnionSanitizerConfigOrSanitizerPresets() const;
void Set(const V8UnionSanitizerConfigOrSanitizerPresets* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Sanitizer or SanitizerConfig or SanitizerPresets)";
}

ContentType content_type_;

Member<Sanitizer> member_sanitizer_;
Member<SanitizerConfig> member_sanitizer_config_;
V8SanitizerPresets member_sanitizer_presets_{static_cast<V8SanitizerPresets::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_SANITIZER_SANITIZERCONFIG_SANITIZERPRESETS_H_
