// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_READABLESTREAMBYOBREADER_READABLESTREAMDEFAULTREADER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_READABLESTREAMBYOBREADER_READABLESTREAMDEFAULTREADER_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ReadableStreamBYOBReader;
class ReadableStreamDefaultReader;
class ScriptState;

class CORE_EXPORT V8UnionReadableStreamBYOBReaderOrReadableStreamDefaultReader final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kReadableStreamBYOBReader, kReadableStreamDefaultReader
};

static V8UnionReadableStreamBYOBReaderOrReadableStreamDefaultReader* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionReadableStreamBYOBReaderOrReadableStreamDefaultReader(ReadableStreamBYOBReader* value) : content_type_(ContentType::kReadableStreamBYOBReader), member_readable_stream_byob_reader_(value) {
  DCHECK(value);
}
explicit  V8UnionReadableStreamBYOBReaderOrReadableStreamDefaultReader(ReadableStreamDefaultReader* value) : content_type_(ContentType::kReadableStreamDefaultReader), member_readable_stream_default_reader_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsReadableStreamBYOBReader() const {
  return content_type_ == ContentType::kReadableStreamBYOBReader;
}
ReadableStreamBYOBReader* GetAsReadableStreamBYOBReader() const {
  DCHECK_EQ(content_type_, ContentType::kReadableStreamBYOBReader);
return member_readable_stream_byob_reader_.Get();
}
void Set(ReadableStreamBYOBReader* value) {
  DCHECK(value);
Clear();
member_readable_stream_byob_reader_ = value;
content_type_ = ContentType::kReadableStreamBYOBReader;
}

bool IsReadableStreamDefaultReader() const {
  return content_type_ == ContentType::kReadableStreamDefaultReader;
}
ReadableStreamDefaultReader* GetAsReadableStreamDefaultReader() const {
  DCHECK_EQ(content_type_, ContentType::kReadableStreamDefaultReader);
return member_readable_stream_default_reader_.Get();
}
void Set(ReadableStreamDefaultReader* value) {
  DCHECK(value);
Clear();
member_readable_stream_default_reader_ = value;
content_type_ = ContentType::kReadableStreamDefaultReader;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ReadableStreamBYOBReader or ReadableStreamDefaultReader)";
}

ContentType content_type_;

Member<ReadableStreamBYOBReader> member_readable_stream_byob_reader_;
Member<ReadableStreamDefaultReader> member_readable_stream_default_reader_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_READABLESTREAMBYOBREADER_READABLESTREAMDEFAULTREADER_H_
