// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OPAQUEPROPERTY_UNSIGNEDLONG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OPAQUEPROPERTY_UNSIGNEDLONG_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_opaque_property.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionOpaquePropertyOrUnsignedLong final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kOpaqueProperty, kUnsignedLong
};

static V8UnionOpaquePropertyOrUnsignedLong* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionOpaquePropertyOrUnsignedLong(V8OpaqueProperty value) : content_type_(ContentType::kOpaqueProperty), member_opaque_property_(value) {
  
}
explicit  V8UnionOpaquePropertyOrUnsignedLong(uint32_t value) : content_type_(ContentType::kUnsignedLong), member_unsigned_long_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsOpaqueProperty() const {
  return content_type_ == ContentType::kOpaqueProperty;
}
V8OpaqueProperty GetAsOpaqueProperty() const {
  DCHECK_EQ(content_type_, ContentType::kOpaqueProperty);
return member_opaque_property_;
}
void Set(V8OpaqueProperty value) {
  Clear();
member_opaque_property_ = value;
content_type_ = ContentType::kOpaqueProperty;
}

bool IsUnsignedLong() const {
  return content_type_ == ContentType::kUnsignedLong;
}
uint32_t GetAsUnsignedLong() const {
  DCHECK_EQ(content_type_, ContentType::kUnsignedLong);
return member_unsigned_long_;
}
void Set(uint32_t value) {
  Clear();
member_unsigned_long_ = value;
content_type_ = ContentType::kUnsignedLong;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(OpaqueProperty or unsigned long)";
}

ContentType content_type_;

V8OpaqueProperty member_opaque_property_{static_cast<V8OpaqueProperty::Enum>(0)};
uint32_t member_unsigned_long_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OPAQUEPROPERTY_UNSIGNEDLONG_H_
