// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OBSERVABLEINSPECTOR_OBSERVERCALLBACK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OBSERVABLEINSPECTOR_OBSERVERCALLBACK_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ObservableInspector;
class ScriptState;
class V8ObserverCallback;

class CORE_EXPORT V8UnionObservableInspectorOrObserverCallback final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kObservableInspector, kObserverCallback
};

static V8UnionObservableInspectorOrObserverCallback* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionObservableInspectorOrObserverCallback(ObservableInspector* value) : content_type_(ContentType::kObservableInspector), member_observable_inspector_(value) {
  DCHECK(value);
}
explicit  V8UnionObservableInspectorOrObserverCallback(V8ObserverCallback* value) : content_type_(ContentType::kObserverCallback), member_observer_callback_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsObservableInspector() const {
  return content_type_ == ContentType::kObservableInspector;
}
ObservableInspector* GetAsObservableInspector() const {
  DCHECK_EQ(content_type_, ContentType::kObservableInspector);
return member_observable_inspector_.Get();
}
void Set(ObservableInspector* value) {
  DCHECK(value);
Clear();
member_observable_inspector_ = value;
content_type_ = ContentType::kObservableInspector;
}

bool IsObserverCallback() const {
  return content_type_ == ContentType::kObserverCallback;
}
V8ObserverCallback* GetAsObserverCallback() const {
  DCHECK_EQ(content_type_, ContentType::kObserverCallback);
return member_observer_callback_.Get();
}
void Set(V8ObserverCallback* value) {
  DCHECK(value);
Clear();
member_observer_callback_ = value;
content_type_ = ContentType::kObserverCallback;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ObservableInspector or ObserverCallback)";
}

ContentType content_type_;

Member<ObservableInspector> member_observable_inspector_;
Member<V8ObserverCallback> member_observer_callback_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OBSERVABLEINSPECTOR_OBSERVERCALLBACK_H_
