// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OBJECT_OBJECTARRAY_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OBJECT_OBJECTARRAY_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;
class V8UnionObjectOrString;

class CORE_EXPORT V8UnionObjectOrObjectArrayOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kObject, kObjectArray, kString
};

static V8UnionObjectOrObjectArrayOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionObjectOrObjectArrayOrString(const ScriptObject& value) : content_type_(ContentType::kObject), member_object_(value) {
  
}
explicit  V8UnionObjectOrObjectArrayOrString(const HeapVector<ScriptObject>& value);
explicit  V8UnionObjectOrObjectArrayOrString(HeapVector<ScriptObject>&& value);
explicit  V8UnionObjectOrObjectArrayOrString(const String& value);
explicit  V8UnionObjectOrObjectArrayOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsObject() const {
  return content_type_ == ContentType::kObject;
}
const ScriptObject& GetAsObject() const {
  DCHECK_EQ(content_type_, ContentType::kObject);
return member_object_;
}
void Set(const ScriptObject& value) {
  Clear();
member_object_ = value;
content_type_ = ContentType::kObject;
}

bool IsObjectArray() const {
  return content_type_ == ContentType::kObjectArray;
}
const HeapVector<ScriptObject>& GetAsObjectArray() const {
  DCHECK_EQ(content_type_, ContentType::kObjectArray);
return member_object_array_;
}
void Set(const HeapVector<ScriptObject>& value);
void Set(HeapVector<ScriptObject>&& value);

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionObjectOrString() const {
  return content_type_ == ContentType::kObject || content_type_ == ContentType::kString;
}
V8UnionObjectOrString* GetAsV8UnionObjectOrString() const;
void Set(const V8UnionObjectOrString* value);
bool IsV8AlgorithmIdentifier() const {
  return IsV8UnionObjectOrString();
}
V8UnionObjectOrString* GetAsV8AlgorithmIdentifier() const {
  return GetAsV8UnionObjectOrString();
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or FrozenArray<object> or object)";
}

ContentType content_type_;

ScriptObject member_object_;
HeapVector<ScriptObject> member_object_array_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_OBJECT_OBJECTARRAY_STRING_H_
