// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_KEYFRAMEANIMATIONOPTIONS_UNRESTRICTEDDOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_KEYFRAMEANIMATIONOPTIONS_UNRESTRICTEDDOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class KeyframeAnimationOptions;
class ScriptState;

class CORE_EXPORT V8UnionKeyframeAnimationOptionsOrUnrestrictedDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kKeyframeAnimationOptions, kUnrestrictedDouble
};

static V8UnionKeyframeAnimationOptionsOrUnrestrictedDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionKeyframeAnimationOptionsOrUnrestrictedDouble(KeyframeAnimationOptions* value) : content_type_(ContentType::kKeyframeAnimationOptions), member_keyframe_animation_options_(value) {
  DCHECK(value);
}
explicit  V8UnionKeyframeAnimationOptionsOrUnrestrictedDouble(double value) : content_type_(ContentType::kUnrestrictedDouble), member_unrestricted_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsKeyframeAnimationOptions() const {
  return content_type_ == ContentType::kKeyframeAnimationOptions;
}
KeyframeAnimationOptions* GetAsKeyframeAnimationOptions() const {
  DCHECK_EQ(content_type_, ContentType::kKeyframeAnimationOptions);
return member_keyframe_animation_options_.Get();
}
void Set(KeyframeAnimationOptions* value) {
  DCHECK(value);
Clear();
member_keyframe_animation_options_ = value;
content_type_ = ContentType::kKeyframeAnimationOptions;
}

bool IsUnrestrictedDouble() const {
  return content_type_ == ContentType::kUnrestrictedDouble;
}
double GetAsUnrestrictedDouble() const {
  DCHECK_EQ(content_type_, ContentType::kUnrestrictedDouble);
return member_unrestricted_double_;
}
void Set(double value) {
  Clear();
member_unrestricted_double_ = value;
content_type_ = ContentType::kUnrestrictedDouble;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(KeyframeAnimationOptions or unrestricted double)";
}

ContentType content_type_;

Member<KeyframeAnimationOptions> member_keyframe_animation_options_;
double member_unrestricted_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_KEYFRAMEANIMATIONOPTIONS_UNRESTRICTEDDOUBLE_H_
