// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_INTERNALENUM_INTERNALENUMSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_INTERNALENUM_INTERNALENUMSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_internal_enum.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;
class ScriptState;

class  V8UnionInternalEnumOrInternalEnumSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kInternalEnum, kInternalEnumSequence
};

static V8UnionInternalEnumOrInternalEnumSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionInternalEnumOrInternalEnumSequence(V8InternalEnum value) : content_type_(ContentType::kInternalEnum), member_internal_enum_(value) {
  
}
explicit  V8UnionInternalEnumOrInternalEnumSequence(const Vector<V8InternalEnum>& value);
explicit  V8UnionInternalEnumOrInternalEnumSequence(Vector<V8InternalEnum>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsInternalEnum() const {
  return content_type_ == ContentType::kInternalEnum;
}
V8InternalEnum GetAsInternalEnum() const {
  DCHECK_EQ(content_type_, ContentType::kInternalEnum);
return member_internal_enum_;
}
void Set(V8InternalEnum value) {
  Clear();
member_internal_enum_ = value;
content_type_ = ContentType::kInternalEnum;
}

bool IsInternalEnumSequence() const {
  return content_type_ == ContentType::kInternalEnumSequence;
}
const Vector<V8InternalEnum>& GetAsInternalEnumSequence() const {
  DCHECK_EQ(content_type_, ContentType::kInternalEnumSequence);
return member_internal_enum_sequence_;
}
void Set(const Vector<V8InternalEnum>& value);
void Set(Vector<V8InternalEnum>&& value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(InternalEnum or sequence<InternalEnum>)";
}

ContentType content_type_;

V8InternalEnum member_internal_enum_{static_cast<V8InternalEnum::Enum>(0)};
Vector<V8InternalEnum> member_internal_enum_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_INTERNALENUM_INTERNALENUMSEQUENCE_H_
