// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_internalenum_internalenumsequence.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionInternalEnumOrInternalEnumSequence* V8UnionInternalEnumOrInternalEnumSequence::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<V8InternalEnum>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionInternalEnumOrInternalEnumSequence>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<V8InternalEnum>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionInternalEnumOrInternalEnumSequence>(std::move(blink_value));
}
}
{
  auto&& blink_value = NativeValueTraits<V8InternalEnum>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionInternalEnumOrInternalEnumSequence>(blink_value);
}
}

 V8UnionInternalEnumOrInternalEnumSequence::V8UnionInternalEnumOrInternalEnumSequence(const Vector<V8InternalEnum>& value) : content_type_(ContentType::kInternalEnumSequence), member_internal_enum_sequence_(value) {
  
}

 V8UnionInternalEnumOrInternalEnumSequence::V8UnionInternalEnumOrInternalEnumSequence(Vector<V8InternalEnum>&& value) : content_type_(ContentType::kInternalEnumSequence), member_internal_enum_sequence_(std::move(value)) {
  
}







void V8UnionInternalEnumOrInternalEnumSequence::Set(const Vector<V8InternalEnum>& value) {
  Clear();
member_internal_enum_sequence_ = value;
content_type_ = ContentType::kInternalEnumSequence;
}

void V8UnionInternalEnumOrInternalEnumSequence::Set(Vector<V8InternalEnum>&& value) {
  Clear();
member_internal_enum_sequence_ = std::move(value);
content_type_ = ContentType::kInternalEnumSequence;
}


v8::Local<v8::Value> V8UnionInternalEnumOrInternalEnumSequence::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kInternalEnum: {
    return ToV8Traits<V8InternalEnum>::ToV8(script_state, member_internal_enum_);
  }
  case ContentType::kInternalEnumSequence: {
    return ToV8Traits<IDLSequence<V8InternalEnum>>::ToV8(script_state, member_internal_enum_sequence_);
  }
}

NOTREACHED();
}

void V8UnionInternalEnumOrInternalEnumSequence::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionInternalEnumOrInternalEnumSequence::Clear() {
  member_internal_enum_sequence_.clear();
}



}  // namespace blink
