// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_htmlscriptelement_svgscriptelement.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_script_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_svg_script_element.h"
#include "third_party/blink/renderer/core/html/html_script_element.h"
#include "third_party/blink/renderer/core/svg/svg_script_element.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionHTMLScriptElementOrSVGScriptElement* V8UnionHTMLScriptElementOrSVGScriptElement::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8SVGScriptElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8SVGScriptElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionHTMLScriptElementOrSVGScriptElement>(blink_value);
}
if (V8HTMLScriptElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLScriptElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionHTMLScriptElementOrSVGScriptElement>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionHTMLScriptElementOrSVGScriptElement::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kHTMLScriptElement: {
    return ToV8Traits<HTMLScriptElement>::ToV8(script_state, member_html_script_element_.Get());
  }
  case ContentType::kSVGScriptElement: {
    return ToV8Traits<SVGScriptElement>::ToV8(script_state, member_svg_script_element_.Get());
  }
}

NOTREACHED();
}

void V8UnionHTMLScriptElementOrSVGScriptElement::Trace(Visitor* visitor) const {
  visitor->Trace(member_html_script_element_);
visitor->Trace(member_svg_script_element_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionHTMLScriptElementOrSVGScriptElement::Clear() {
  member_html_script_element_.Clear();
member_svg_script_element_.Clear();
}



}  // namespace blink
