// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLOPTGROUPELEMENT_HTMLOPTIONELEMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLOPTGROUPELEMENT_HTMLOPTIONELEMENT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLOptGroupElement;
class HTMLOptionElement;
class ScriptState;

class CORE_EXPORT V8UnionHTMLOptGroupElementOrHTMLOptionElement final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kHTMLOptGroupElement, kHTMLOptionElement
};

static V8UnionHTMLOptGroupElementOrHTMLOptionElement* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionHTMLOptGroupElementOrHTMLOptionElement(HTMLOptGroupElement* value) : content_type_(ContentType::kHTMLOptGroupElement), member_html_opt_group_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLOptGroupElementOrHTMLOptionElement(HTMLOptionElement* value) : content_type_(ContentType::kHTMLOptionElement), member_html_option_element_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsHTMLOptGroupElement() const {
  return content_type_ == ContentType::kHTMLOptGroupElement;
}
HTMLOptGroupElement* GetAsHTMLOptGroupElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLOptGroupElement);
return member_html_opt_group_element_.Get();
}
void Set(HTMLOptGroupElement* value) {
  DCHECK(value);
Clear();
member_html_opt_group_element_ = value;
content_type_ = ContentType::kHTMLOptGroupElement;
}

bool IsHTMLOptionElement() const {
  return content_type_ == ContentType::kHTMLOptionElement;
}
HTMLOptionElement* GetAsHTMLOptionElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLOptionElement);
return member_html_option_element_.Get();
}
void Set(HTMLOptionElement* value) {
  DCHECK(value);
Clear();
member_html_option_element_ = value;
content_type_ = ContentType::kHTMLOptionElement;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(HTMLOptGroupElement or HTMLOptionElement)";
}

ContentType content_type_;

Member<HTMLOptGroupElement> member_html_opt_group_element_;
Member<HTMLOptionElement> member_html_option_element_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLOPTGROUPELEMENT_HTMLOPTIONELEMENT_H_
