// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_htmlcanvaselement_offscreencanvas.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_canvas_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/core/html/canvas/html_canvas_element.h"
#include "third_party/blink/renderer/core/offscreencanvas/offscreen_canvas.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionHTMLCanvasElementOrOffscreenCanvas* V8UnionHTMLCanvasElementOrOffscreenCanvas::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8HTMLCanvasElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLCanvasElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionHTMLCanvasElementOrOffscreenCanvas>(blink_value);
}
if (V8OffscreenCanvas::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8OffscreenCanvas::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionHTMLCanvasElementOrOffscreenCanvas>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionHTMLCanvasElementOrOffscreenCanvas::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kHTMLCanvasElement: {
    return ToV8Traits<HTMLCanvasElement>::ToV8(script_state, member_html_canvas_element_.Get());
  }
  case ContentType::kOffscreenCanvas: {
    return ToV8Traits<OffscreenCanvas>::ToV8(script_state, member_offscreen_canvas_.Get());
  }
}

NOTREACHED();
}

void V8UnionHTMLCanvasElementOrOffscreenCanvas::Trace(Visitor* visitor) const {
  visitor->Trace(member_html_canvas_element_);
visitor->Trace(member_offscreen_canvas_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionHTMLCanvasElementOrOffscreenCanvas::Clear() {
  member_html_canvas_element_.Clear();
member_offscreen_canvas_.Clear();
}



}  // namespace blink
