// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FLOAT_16_ARRAY_FLOAT_32_ARRAY_UINT_8_CLAMPEDARRAY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FLOAT_16_ARRAY_FLOAT_32_ARRAY_UINT_8_CLAMPEDARRAY_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kFloat16Array, kFloat32Array, kUint8ClampedArray
};

static V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray(NotShared<DOMFloat16Array> value) : content_type_(ContentType::kFloat16Array), member_float_16_array_(value) {
  DCHECK(value);
}
explicit  V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray(NotShared<DOMFloat32Array> value) : content_type_(ContentType::kFloat32Array), member_float32_array_(value) {
  DCHECK(value);
}
explicit  V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray(NotShared<DOMUint8ClampedArray> value) : content_type_(ContentType::kUint8ClampedArray), member_uint8_clamped_array_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsFloat16Array() const {
  return content_type_ == ContentType::kFloat16Array;
}
NotShared<DOMFloat16Array> GetAsFloat16Array() const {
  DCHECK_EQ(content_type_, ContentType::kFloat16Array);
return member_float_16_array_;
}
void Set(NotShared<DOMFloat16Array> value) {
  DCHECK(value);
Clear();
member_float_16_array_ = value;
content_type_ = ContentType::kFloat16Array;
}

bool IsFloat32Array() const {
  return content_type_ == ContentType::kFloat32Array;
}
NotShared<DOMFloat32Array> GetAsFloat32Array() const {
  DCHECK_EQ(content_type_, ContentType::kFloat32Array);
return member_float32_array_;
}
void Set(NotShared<DOMFloat32Array> value) {
  DCHECK(value);
Clear();
member_float32_array_ = value;
content_type_ = ContentType::kFloat32Array;
}

bool IsUint8ClampedArray() const {
  return content_type_ == ContentType::kUint8ClampedArray;
}
NotShared<DOMUint8ClampedArray> GetAsUint8ClampedArray() const {
  DCHECK_EQ(content_type_, ContentType::kUint8ClampedArray);
return member_uint8_clamped_array_;
}
void Set(NotShared<DOMUint8ClampedArray> value) {
  DCHECK(value);
Clear();
member_uint8_clamped_array_ = value;
content_type_ = ContentType::kUint8ClampedArray;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Float16Array or Float32Array or Uint8ClampedArray)";
}

ContentType content_type_;

NotShared<DOMFloat16Array> member_float_16_array_;
NotShared<DOMFloat32Array> member_float32_array_;
NotShared<DOMUint8ClampedArray> member_uint8_clamped_array_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FLOAT_16_ARRAY_FLOAT_32_ARRAY_UINT_8_CLAMPEDARRAY_H_
