// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_float16array_float32array_uint8clampedarray.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray* V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsUint8ClampedArray()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMUint8ClampedArray>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray>(blink_value);
}
if (v8_value->IsFloat16Array()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMFloat16Array>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray>(blink_value);
}
if (v8_value->IsFloat32Array()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMFloat32Array>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













v8::Local<v8::Value> V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kFloat16Array: {
    return ToV8Traits<NotShared<DOMFloat16Array>>::ToV8(script_state, member_float_16_array_);
  }
  case ContentType::kFloat32Array: {
    return ToV8Traits<NotShared<DOMFloat32Array>>::ToV8(script_state, member_float32_array_);
  }
  case ContentType::kUint8ClampedArray: {
    return ToV8Traits<NotShared<DOMUint8ClampedArray>>::ToV8(script_state, member_uint8_clamped_array_);
  }
}

NOTREACHED();
}

void V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray::Trace(Visitor* visitor) const {
  visitor->Trace(member_float_16_array_);
visitor->Trace(member_float32_array_);
visitor->Trace(member_uint8_clamped_array_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionFloat16ArrayOrFloat32ArrayOrUint8ClampedArray::Clear() {
  member_float_16_array_.Clear();
member_float32_array_.Clear();
member_uint8_clamped_array_.Clear();
}



}  // namespace blink
