// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FILE_FORMDATA_USVSTRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FILE_FORMDATA_USVSTRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class File;
class FormData;
class ScriptState;
class V8UnionFileOrUSVString;

class CORE_EXPORT V8UnionFileOrFormDataOrUSVString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kFile, kFormData, kUSVString
};

static V8UnionFileOrFormDataOrUSVString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionFileOrFormDataOrUSVString(File* value) : content_type_(ContentType::kFile), member_file_(value) {
  DCHECK(value);
}
explicit  V8UnionFileOrFormDataOrUSVString(FormData* value) : content_type_(ContentType::kFormData), member_form_data_(value) {
  DCHECK(value);
}
explicit  V8UnionFileOrFormDataOrUSVString(const String& value);
explicit  V8UnionFileOrFormDataOrUSVString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsFile() const {
  return content_type_ == ContentType::kFile;
}
File* GetAsFile() const {
  DCHECK_EQ(content_type_, ContentType::kFile);
return member_file_.Get();
}
void Set(File* value) {
  DCHECK(value);
Clear();
member_file_ = value;
content_type_ = ContentType::kFile;
}

bool IsFormData() const {
  return content_type_ == ContentType::kFormData;
}
FormData* GetAsFormData() const {
  DCHECK_EQ(content_type_, ContentType::kFormData);
return member_form_data_.Get();
}
void Set(FormData* value) {
  DCHECK(value);
Clear();
member_form_data_ = value;
content_type_ = ContentType::kFormData;
}

bool IsUSVString() const {
  return content_type_ == ContentType::kUSVString;
}
const String& GetAsUSVString() const {
  DCHECK_EQ(content_type_, ContentType::kUSVString);
return member_usv_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionFileOrUSVString() const {
  return content_type_ == ContentType::kFile || content_type_ == ContentType::kUSVString;
}
V8UnionFileOrUSVString* GetAsV8UnionFileOrUSVString() const;
void Set(const V8UnionFileOrUSVString* value);
bool IsV8FormDataEntryValue() const {
  return IsV8UnionFileOrUSVString();
}
V8UnionFileOrUSVString* GetAsV8FormDataEntryValue() const {
  return GetAsV8UnionFileOrUSVString();
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(File or FormData or USVString)";
}

ContentType content_type_;

Member<File> member_file_;
Member<FormData> member_form_data_;
String member_usv_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FILE_FORMDATA_USVSTRING_H_
