// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string_timelinerangeoffset.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_timeline_range_offset.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_timelinerangeoffset.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDoubleOrStringOrTimelineRangeOffset* V8UnionDoubleOrStringOrTimelineRangeOffset::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = TimelineRangeOffset::Create(isolate);
return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<TimelineRangeOffset>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(blink_value);
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(std::move(blink_value));
}
}

 V8UnionDoubleOrStringOrTimelineRangeOffset::V8UnionDoubleOrStringOrTimelineRangeOffset(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionDoubleOrStringOrTimelineRangeOffset::V8UnionDoubleOrStringOrTimelineRangeOffset(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionDoubleOrStringOrTimelineRangeOffset::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionDoubleOrStringOrTimelineRangeOffset::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}





V8UnionDoubleOrString* V8UnionDoubleOrStringOrTimelineRangeOffset::GetAsV8UnionDoubleOrString() const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return MakeGarbageCollected<V8UnionDoubleOrString>(GetAsDouble());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionDoubleOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrStringOrTimelineRangeOffset::Set(const V8UnionDoubleOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionDoubleOrString::ContentType::kDouble: {
    Set(value->GetAsDouble());
    break;
  }
  case V8UnionDoubleOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionStringOrTimelineRangeOffset* V8UnionDoubleOrStringOrTimelineRangeOffset::GetAsV8UnionStringOrTimelineRangeOffset() const {
  switch (content_type_) {
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionStringOrTimelineRangeOffset>(GetAsString());
  }
  case ContentType::kTimelineRangeOffset: {
    return MakeGarbageCollected<V8UnionStringOrTimelineRangeOffset>(GetAsTimelineRangeOffset());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrStringOrTimelineRangeOffset::Set(const V8UnionStringOrTimelineRangeOffset* value) {
  switch (value->GetContentType()) {
  case V8UnionStringOrTimelineRangeOffset::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
  case V8UnionStringOrTimelineRangeOffset::ContentType::kTimelineRangeOffset: {
    Set(value->GetAsTimelineRangeOffset());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionDoubleOrStringOrTimelineRangeOffset::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return ToV8Traits<IDLDouble>::ToV8(script_state, member_double_);
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kTimelineRangeOffset: {
    return ToV8Traits<TimelineRangeOffset>::ToV8(script_state, member_timeline_range_offset_.Get());
  }
}

NOTREACHED();
}

void V8UnionDoubleOrStringOrTimelineRangeOffset::Trace(Visitor* visitor) const {
  visitor->Trace(member_timeline_range_offset_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionDoubleOrStringOrTimelineRangeOffset::Clear() {
  member_double_ = 0;
member_string_ = String();
member_timeline_range_offset_.Clear();
}



}  // namespace blink
