// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDoubleOrString* V8UnionDoubleOrString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrString>(std::move(blink_value));
}
}

 V8UnionDoubleOrString::V8UnionDoubleOrString(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionDoubleOrString::V8UnionDoubleOrString(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}









void V8UnionDoubleOrString::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionDoubleOrString::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}


v8::Local<v8::Value> V8UnionDoubleOrString::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return ToV8Traits<IDLDouble>::ToV8(script_state, member_double_);
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
}

NOTREACHED();
}

void V8UnionDoubleOrString::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionDoubleOrString::Clear() {
  member_double_ = 0;
member_string_ = String();
}



}  // namespace blink
