// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_INTERNALENUM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_INTERNALENUM_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_internal_enum.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"

namespace blink {

class ExceptionState;
class ScriptState;

class  V8UnionDoubleOrInternalEnum final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDouble, kInternalEnum
};

static V8UnionDoubleOrInternalEnum* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDoubleOrInternalEnum(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}
explicit  V8UnionDoubleOrInternalEnum(V8InternalEnum value) : content_type_(ContentType::kInternalEnum), member_internal_enum_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}

bool IsInternalEnum() const {
  return content_type_ == ContentType::kInternalEnum;
}
V8InternalEnum GetAsInternalEnum() const {
  DCHECK_EQ(content_type_, ContentType::kInternalEnum);
return member_internal_enum_;
}
void Set(V8InternalEnum value) {
  Clear();
member_internal_enum_ = value;
content_type_ = ContentType::kInternalEnum;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(InternalEnum or double)";
}

ContentType content_type_;

double member_double_;
V8InternalEnum member_internal_enum_{static_cast<V8InternalEnum::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_INTERNALENUM_H_
