// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_DOUBLEORSTRINGORTIMELINERANGEOFFSETORNULLSEQUENCE_STRING_TIMELINERANGEOFFSET_NULL_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_DOUBLEORSTRINGORTIMELINERANGEOFFSETORNULLSEQUENCE_STRING_TIMELINERANGEOFFSET_NULL_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;
class TimelineRangeOffset;
class V8UnionDoubleOrString;
class V8UnionDoubleOrStringOrTimelineRangeOffset;
class V8UnionStringOrTimelineRangeOffset;

class CORE_EXPORT V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDouble, kDoubleOrStringOrTimelineRangeOffsetOrNullSequence, kString, kTimelineRangeOffset, kNull
};

static V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}
explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(const HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>& value);
explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>&& value);
explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(const String& value);
explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(String&& value);
explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(TimelineRangeOffset* value) : content_type_(ContentType::kTimelineRangeOffset), member_timeline_range_offset_(value) {
  DCHECK(value);
}
explicit  V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(std::nullptr_t) : content_type_(ContentType::kNull) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}

bool IsDoubleOrStringOrTimelineRangeOffsetOrNullSequence() const {
  return content_type_ == ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence;
}
const HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>& GetAsDoubleOrStringOrTimelineRangeOffsetOrNullSequence() const {
  DCHECK_EQ(content_type_, ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence);
return member_double_or_string_or_timeline_range_offset_or_null_sequence_;
}
void Set(const HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>& value);
void Set(HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>&& value);

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsTimelineRangeOffset() const {
  return content_type_ == ContentType::kTimelineRangeOffset;
}
TimelineRangeOffset* GetAsTimelineRangeOffset() const {
  DCHECK_EQ(content_type_, ContentType::kTimelineRangeOffset);
return member_timeline_range_offset_.Get();
}
void Set(TimelineRangeOffset* value) {
  DCHECK(value);
Clear();
member_timeline_range_offset_ = value;
content_type_ = ContentType::kTimelineRangeOffset;
}

bool IsNull() const {
  return content_type_ == ContentType::kNull;
}
void Set(std::nullptr_t) {
  Clear();
content_type_ = ContentType::kNull;
}

bool IsV8UnionDoubleOrString() const {
  return content_type_ == ContentType::kDouble || content_type_ == ContentType::kString;
}
V8UnionDoubleOrString* GetAsV8UnionDoubleOrString() const;
void Set(const V8UnionDoubleOrString* value);

bool IsV8UnionDoubleOrStringOrTimelineRangeOffset() const {
  return content_type_ == ContentType::kDouble || content_type_ == ContentType::kString || content_type_ == ContentType::kTimelineRangeOffset;
}
V8UnionDoubleOrStringOrTimelineRangeOffset* GetAsV8UnionDoubleOrStringOrTimelineRangeOffset() const;
void Set(const V8UnionDoubleOrStringOrTimelineRangeOffset* value);
bool IsV8KeyframeOffset() const {
  return IsV8UnionDoubleOrStringOrTimelineRangeOffset();
}
V8UnionDoubleOrStringOrTimelineRangeOffset* GetAsV8KeyframeOffset() const {
  return GetAsV8UnionDoubleOrStringOrTimelineRangeOffset();
}

bool IsV8UnionStringOrTimelineRangeOffset() const {
  return content_type_ == ContentType::kString || content_type_ == ContentType::kTimelineRangeOffset;
}
V8UnionStringOrTimelineRangeOffset* GetAsV8UnionStringOrTimelineRangeOffset() const;
void Set(const V8UnionStringOrTimelineRangeOffset* value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or TimelineRangeOffset or double or sequence<KeyframeOffset?>)?";
}

ContentType content_type_;

double member_double_;
HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>> member_double_or_string_or_timeline_range_offset_or_null_sequence_;
String member_string_;
Member<TimelineRangeOffset> member_timeline_range_offset_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOUBLE_DOUBLEORSTRINGORTIMELINERANGEOFFSETORNULLSEQUENCE_STRING_TIMELINERANGEOFFSET_NULL_H_
