// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_string_unrestricteddouble.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_string.h"
#include "third_party/blink/renderer/core/css/cssom/css_numeric_value.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8CSSNumericValue::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8CSSNumericValue::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble>(blink_value);
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble>(std::move(blink_value));
}
}

 V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::V8UnionCSSNumericValueOrStringOrUnrestrictedDouble(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::V8UnionCSSNumericValueOrStringOrUnrestrictedDouble(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}





V8UnionCSSNumericValueOrString* V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::GetAsV8UnionCSSNumericValueOrString() const {
  switch (content_type_) {
  case ContentType::kCSSNumericValue: {
    return MakeGarbageCollected<V8UnionCSSNumericValueOrString>(GetAsCSSNumericValue());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionCSSNumericValueOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::Set(const V8UnionCSSNumericValueOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionCSSNumericValueOrString::ContentType::kCSSNumericValue: {
    Set(value->GetAsCSSNumericValue());
    break;
  }
  case V8UnionCSSNumericValueOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kCSSNumericValue: {
    return ToV8Traits<CSSNumericValue>::ToV8(script_state, member_css_numeric_value_.Get());
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kUnrestrictedDouble: {
    return ToV8Traits<IDLUnrestrictedDouble>::ToV8(script_state, member_unrestricted_double_);
  }
}

NOTREACHED();
}

void V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::Trace(Visitor* visitor) const {
  visitor->Trace(member_css_numeric_value_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionCSSNumericValueOrStringOrUnrestrictedDouble::Clear() {
  member_css_numeric_value_.Clear();
member_string_ = String();
member_unrestricted_double_ = 0;
}



}  // namespace blink
