// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSCOLORVALUE_CSSSTYLEVALUE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSCOLORVALUE_CSSSTYLEVALUE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CSSColorValue;
class CSSStyleValue;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionCSSColorValueOrCSSStyleValue final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kCSSColorValue, kCSSStyleValue
};

static V8UnionCSSColorValueOrCSSStyleValue* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionCSSColorValueOrCSSStyleValue(CSSColorValue* value) : content_type_(ContentType::kCSSColorValue), member_css_color_value_(value) {
  DCHECK(value);
}
explicit  V8UnionCSSColorValueOrCSSStyleValue(CSSStyleValue* value) : content_type_(ContentType::kCSSStyleValue), member_css_style_value_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsCSSColorValue() const {
  return content_type_ == ContentType::kCSSColorValue;
}
CSSColorValue* GetAsCSSColorValue() const {
  DCHECK_EQ(content_type_, ContentType::kCSSColorValue);
return member_css_color_value_.Get();
}
void Set(CSSColorValue* value) {
  DCHECK(value);
Clear();
member_css_color_value_ = value;
content_type_ = ContentType::kCSSColorValue;
}

bool IsCSSStyleValue() const {
  return content_type_ == ContentType::kCSSStyleValue;
}
CSSStyleValue* GetAsCSSStyleValue() const {
  DCHECK_EQ(content_type_, ContentType::kCSSStyleValue);
return member_css_style_value_.Get();
}
void Set(CSSStyleValue* value) {
  DCHECK(value);
Clear();
member_css_style_value_ = value;
content_type_ = ContentType::kCSSStyleValue;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(CSSColorValue or CSSStyleValue)";
}

ContentType content_type_;

Member<CSSColorValue> member_css_color_value_;
Member<CSSStyleValue> member_css_style_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSCOLORVALUE_CSSSTYLEVALUE_H_
