// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BOOLEAN_BYTESTRINGBYTESTRINGRECORD_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BOOLEAN_BYTESTRINGBYTESTRINGRECORD_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionBooleanOrByteStringByteStringRecord final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kBoolean, kByteStringByteStringRecord
};

static V8UnionBooleanOrByteStringByteStringRecord* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionBooleanOrByteStringByteStringRecord(bool value) : content_type_(ContentType::kBoolean), member_boolean_(value) {
  
}
explicit  V8UnionBooleanOrByteStringByteStringRecord(const Vector<std::pair<String, String>>& value);
explicit  V8UnionBooleanOrByteStringByteStringRecord(Vector<std::pair<String, String>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsBoolean() const {
  return content_type_ == ContentType::kBoolean;
}
bool GetAsBoolean() const {
  DCHECK_EQ(content_type_, ContentType::kBoolean);
return member_boolean_;
}
void Set(bool value) {
  Clear();
member_boolean_ = value;
content_type_ = ContentType::kBoolean;
}

bool IsByteStringByteStringRecord() const {
  return content_type_ == ContentType::kByteStringByteStringRecord;
}
const Vector<std::pair<String, String>>& GetAsByteStringByteStringRecord() const {
  DCHECK_EQ(content_type_, ContentType::kByteStringByteStringRecord);
return member_byte_string_byte_string_record_;
}
void Set(const Vector<std::pair<String, String>>& value);
void Set(Vector<std::pair<String, String>>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(boolean or record<ByteString, ByteString>)";
}

ContentType content_type_;

bool member_boolean_;
Vector<std::pair<String, String>> member_byte_string_byte_string_record_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BOOLEAN_BYTESTRINGBYTESTRINGRECORD_H_
