// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_audiotrack_texttrack_videotrack.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_audio_track.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_track.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_video_track.h"
#include "third_party/blink/renderer/core/html/track/audio_track.h"
#include "third_party/blink/renderer/core/html/track/text_track.h"
#include "third_party/blink/renderer/core/html/track/video_track.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionAudioTrackOrTextTrackOrVideoTrack* V8UnionAudioTrackOrTextTrackOrVideoTrack::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8TextTrack::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8TextTrack::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionAudioTrackOrTextTrackOrVideoTrack>(blink_value);
}
if (V8VideoTrack::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8VideoTrack::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionAudioTrackOrTextTrackOrVideoTrack>(blink_value);
}
if (V8AudioTrack::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8AudioTrack::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionAudioTrackOrTextTrackOrVideoTrack>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













v8::Local<v8::Value> V8UnionAudioTrackOrTextTrackOrVideoTrack::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kAudioTrack: {
    return ToV8Traits<AudioTrack>::ToV8(script_state, member_audio_track_.Get());
  }
  case ContentType::kTextTrack: {
    return ToV8Traits<TextTrack>::ToV8(script_state, member_text_track_.Get());
  }
  case ContentType::kVideoTrack: {
    return ToV8Traits<VideoTrack>::ToV8(script_state, member_video_track_.Get());
  }
}

NOTREACHED();
}

void V8UnionAudioTrackOrTextTrackOrVideoTrack::Trace(Visitor* visitor) const {
  visitor->Trace(member_audio_track_);
visitor->Trace(member_text_track_);
visitor->Trace(member_video_track_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionAudioTrackOrTextTrackOrVideoTrack::Clear() {
  member_audio_track_.Clear();
member_text_track_.Clear();
member_video_track_.Clear();
}



}  // namespace blink
