// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFERALLOWSHARED_ARRAYBUFFERVIEWALLOWSHARED_READABLESTREAM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFERALLOWSHARED_ARRAYBUFFERVIEWALLOWSHARED_READABLESTREAM_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ReadableStream;
class ScriptState;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared;

class CORE_EXPORT V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kArrayBufferAllowShared, kArrayBufferViewAllowShared, kReadableStream
};

static V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream(DOMArrayBufferBase* value) : content_type_(ContentType::kArrayBufferAllowShared), member_array_buffer_allow_shared_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream(MaybeShared<DOMArrayBufferView> value) : content_type_(ContentType::kArrayBufferViewAllowShared), member_array_buffer_view_allow_shared_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream(ReadableStream* value) : content_type_(ContentType::kReadableStream), member_readable_stream_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsArrayBufferAllowShared() const {
  return content_type_ == ContentType::kArrayBufferAllowShared;
}
DOMArrayBufferBase* GetAsArrayBufferAllowShared() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBufferAllowShared);
return member_array_buffer_allow_shared_.Get();
}
void Set(DOMArrayBufferBase* value) {
  DCHECK(value);
Clear();
member_array_buffer_allow_shared_ = value;
content_type_ = ContentType::kArrayBufferAllowShared;
}

bool IsArrayBufferViewAllowShared() const {
  return content_type_ == ContentType::kArrayBufferViewAllowShared;
}
MaybeShared<DOMArrayBufferView> GetAsArrayBufferViewAllowShared() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBufferViewAllowShared);
return member_array_buffer_view_allow_shared_;
}
void Set(MaybeShared<DOMArrayBufferView> value) {
  DCHECK(value);
Clear();
member_array_buffer_view_allow_shared_ = value;
content_type_ = ContentType::kArrayBufferViewAllowShared;
}

bool IsReadableStream() const {
  return content_type_ == ContentType::kReadableStream;
}
ReadableStream* GetAsReadableStream() const {
  DCHECK_EQ(content_type_, ContentType::kReadableStream);
return member_readable_stream_.Get();
}
void Set(ReadableStream* value) {
  DCHECK(value);
Clear();
member_readable_stream_ = value;
content_type_ = ContentType::kReadableStream;
}

bool IsV8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared() const {
  return content_type_ == ContentType::kArrayBufferAllowShared || content_type_ == ContentType::kArrayBufferViewAllowShared;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* GetAsV8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared() const;
void Set(const V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value);
bool IsV8AllowSharedBufferSource() const {
  return IsV8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared();
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* GetAsV8AllowSharedBufferSource() const {
  return GetAsV8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared();
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ReadableStream or [AllowShared] ArrayBuffer or [AllowShared] ArrayBufferView)";
}

ContentType content_type_;

Member<DOMArrayBufferBase> member_array_buffer_allow_shared_;
MaybeShared<DOMArrayBufferView> member_array_buffer_view_allow_shared_;
Member<ReadableStream> member_readable_stream_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFERALLOWSHARED_ARRAYBUFFERVIEWALLOWSHARED_READABLESTREAM_H_
