// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared_readablestream.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared.h"
#include "third_party/blink/renderer/core/streams/readable_stream.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream* V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8ReadableStream::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ReadableStream::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream>(blink_value);
}
if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBufferBase>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream>(blink_value);
}
if (v8_value->IsArrayBufferView()) {
  auto&& blink_value = NativeValueTraits<MaybeShared<DOMArrayBufferView>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream::GetAsV8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared() const {
  switch (content_type_) {
  case ContentType::kArrayBufferAllowShared: {
    return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared>(GetAsArrayBufferAllowShared());
  }
  case ContentType::kArrayBufferViewAllowShared: {
    return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared>(GetAsArrayBufferViewAllowShared());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream::Set(const V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared::ContentType::kArrayBufferAllowShared: {
    Set(value->GetAsArrayBufferAllowShared());
    break;
  }
  case V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared::ContentType::kArrayBufferViewAllowShared: {
    Set(value->GetAsArrayBufferViewAllowShared());
    break;
  }
}
}




void V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_allow_shared_);
visitor->Trace(member_array_buffer_view_allow_shared_);
visitor->Trace(member_readable_stream_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream::Clear() {
  member_array_buffer_allow_shared_.Clear();
member_array_buffer_view_allow_shared_.Clear();
member_readable_stream_.Clear();
}



}  // namespace blink
