// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;
class V8UnionArrayBufferOrArrayBufferView;
class V8UnionArrayBufferOrString;

class CORE_EXPORT V8UnionArrayBufferOrArrayBufferViewOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kArrayBuffer, kArrayBufferView, kString, kV8CSSOMString = kString
};

static V8UnionArrayBufferOrArrayBufferViewOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionArrayBufferOrArrayBufferViewOrString(DOMArrayBuffer* value) : content_type_(ContentType::kArrayBuffer), member_array_buffer_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrString(NotShared<DOMArrayBufferView> value) : content_type_(ContentType::kArrayBufferView), member_array_buffer_view_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrString(const String& value);
explicit  V8UnionArrayBufferOrArrayBufferViewOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsArrayBuffer() const {
  return content_type_ == ContentType::kArrayBuffer;
}
DOMArrayBuffer* GetAsArrayBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBuffer);
return member_array_buffer_.Get();
}
void Set(DOMArrayBuffer* value) {
  DCHECK(value);
Clear();
member_array_buffer_ = value;
content_type_ = ContentType::kArrayBuffer;
}

bool IsArrayBufferView() const {
  return content_type_ == ContentType::kArrayBufferView;
}
NotShared<DOMArrayBufferView> GetAsArrayBufferView() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBufferView);
return member_array_buffer_view_;
}
void Set(NotShared<DOMArrayBufferView> value) {
  DCHECK(value);
Clear();
member_array_buffer_view_ = value;
content_type_ = ContentType::kArrayBufferView;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);
bool IsV8CSSOMString() const {
  return content_type_ == ContentType::kV8CSSOMString;
}
const String& GetAsV8CSSOMString() const {
  DCHECK_EQ(content_type_, ContentType::kV8CSSOMString);
return member_string_;
}

bool IsV8UnionArrayBufferOrArrayBufferView() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView;
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8UnionArrayBufferOrArrayBufferView() const;
void Set(const V8UnionArrayBufferOrArrayBufferView* value);
bool IsV8BinaryData() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BinaryData() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}
bool IsV8BufferSource() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BufferSource() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}

bool IsV8UnionArrayBufferOrString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kString;
}
V8UnionArrayBufferOrString* GetAsV8UnionArrayBufferOrString() const;
void Set(const V8UnionArrayBufferOrString* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ArrayBuffer or ArrayBufferView or DOMString)";
}

ContentType content_type_;

Member<DOMArrayBuffer> member_array_buffer_;
NotShared<DOMArrayBufferView> member_array_buffer_view_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_STRING_H_
