// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ADDEVENTLISTENEROPTIONS_BOOLEAN_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ADDEVENTLISTENEROPTIONS_BOOLEAN_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AddEventListenerOptions;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionAddEventListenerOptionsOrBoolean final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAddEventListenerOptions, kBoolean
};

static V8UnionAddEventListenerOptionsOrBoolean* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAddEventListenerOptionsOrBoolean(AddEventListenerOptions* value) : content_type_(ContentType::kAddEventListenerOptions), member_add_event_listener_options_(value) {
  DCHECK(value);
}
explicit  V8UnionAddEventListenerOptionsOrBoolean(bool value) : content_type_(ContentType::kBoolean), member_boolean_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAddEventListenerOptions() const {
  return content_type_ == ContentType::kAddEventListenerOptions;
}
AddEventListenerOptions* GetAsAddEventListenerOptions() const {
  DCHECK_EQ(content_type_, ContentType::kAddEventListenerOptions);
return member_add_event_listener_options_.Get();
}
void Set(AddEventListenerOptions* value) {
  DCHECK(value);
Clear();
member_add_event_listener_options_ = value;
content_type_ = ContentType::kAddEventListenerOptions;
}

bool IsBoolean() const {
  return content_type_ == ContentType::kBoolean;
}
bool GetAsBoolean() const {
  DCHECK_EQ(content_type_, ContentType::kBoolean);
return member_boolean_;
}
void Set(bool value) {
  Clear();
member_boolean_ = value;
content_type_ = ContentType::kBoolean;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AddEventListenerOptions or boolean)";
}

ContentType content_type_;

Member<AddEventListenerOptions> member_add_event_listener_options_;
bool member_boolean_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ADDEVENTLISTENEROPTIONS_BOOLEAN_H_
