// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UA_DATA_VALUES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UA_DATA_VALUES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class NavigatorUABrandVersion;

class CORE_EXPORT UADataValues : public bindings::DictionaryBase {
  
  public:
static UADataValues* Create() {
  return MakeGarbageCollected<UADataValues>();
}
static UADataValues* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UADataValues>(isolate);
}
static UADataValues* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UADataValues();
explicit  UADataValues(v8::Isolate* isolate);

bool hasArchitecture() const {
  return has_architecture_;
}
const String& architecture() const {
  DCHECK(hasArchitecture());
return member_architecture_;
}
String getArchitectureOr(const String& fallback_value) const;
String getArchitectureOr(String&& fallback_value) const;
void setArchitecture(const String& value);
void setArchitecture(String&& value);

bool hasBitness() const {
  return has_bitness_;
}
const String& bitness() const {
  DCHECK(hasBitness());
return member_bitness_;
}
String getBitnessOr(const String& fallback_value) const;
String getBitnessOr(String&& fallback_value) const;
void setBitness(const String& value);
void setBitness(String&& value);

bool hasBrands() const {
  return has_brands_;
}
const HeapVector<Member<NavigatorUABrandVersion>>& brands() const {
  DCHECK(hasBrands());
return member_brands_;
}
HeapVector<Member<NavigatorUABrandVersion>> getBrandsOr(const HeapVector<Member<NavigatorUABrandVersion>>& fallback_value) const;
HeapVector<Member<NavigatorUABrandVersion>> getBrandsOr(HeapVector<Member<NavigatorUABrandVersion>>&& fallback_value) const;
void setBrands(const HeapVector<Member<NavigatorUABrandVersion>>& value);
void setBrands(HeapVector<Member<NavigatorUABrandVersion>>&& value);

bool hasFormFactors() const {
  return has_form_factors_;
}
const Vector<String>& formFactors() const {
  DCHECK(hasFormFactors());
return member_form_factors_;
}
Vector<String> getFormFactorsOr(const Vector<String>& fallback_value) const;
Vector<String> getFormFactorsOr(Vector<String>&& fallback_value) const;
void setFormFactors(const Vector<String>& value);
void setFormFactors(Vector<String>&& value);

bool hasFullVersionList() const {
  return has_full_version_list_;
}
const HeapVector<Member<NavigatorUABrandVersion>>& fullVersionList() const {
  DCHECK(hasFullVersionList());
return member_full_version_list_;
}
HeapVector<Member<NavigatorUABrandVersion>> getFullVersionListOr(const HeapVector<Member<NavigatorUABrandVersion>>& fallback_value) const;
HeapVector<Member<NavigatorUABrandVersion>> getFullVersionListOr(HeapVector<Member<NavigatorUABrandVersion>>&& fallback_value) const;
void setFullVersionList(const HeapVector<Member<NavigatorUABrandVersion>>& value);
void setFullVersionList(HeapVector<Member<NavigatorUABrandVersion>>&& value);

bool hasMobile() const {
  return has_mobile_;
}
bool mobile() const {
  DCHECK(hasMobile());
return member_mobile_;
}
bool getMobileOr(bool fallback_value) const {
  if (!hasMobile()) {
  return fallback_value;
}
return member_mobile_;
}
void setMobile(bool value) {
  member_mobile_ = value;
has_mobile_ = true;
}

bool hasModel() const {
  return has_model_;
}
const String& model() const {
  DCHECK(hasModel());
return member_model_;
}
String getModelOr(const String& fallback_value) const;
String getModelOr(String&& fallback_value) const;
void setModel(const String& value);
void setModel(String&& value);

bool hasPlatform() const {
  return has_platform_;
}
const String& platform() const {
  DCHECK(hasPlatform());
return member_platform_;
}
String getPlatformOr(const String& fallback_value) const;
String getPlatformOr(String&& fallback_value) const;
void setPlatform(const String& value);
void setPlatform(String&& value);

bool hasPlatformVersion() const {
  return has_platform_version_;
}
const String& platformVersion() const {
  DCHECK(hasPlatformVersion());
return member_platform_version_;
}
String getPlatformVersionOr(const String& fallback_value) const;
String getPlatformVersionOr(String&& fallback_value) const;
void setPlatformVersion(const String& value);
void setPlatformVersion(String&& value);

bool hasUaFullVersion() const {
  return has_ua_full_version_;
}
const String& uaFullVersion() const {
  DCHECK(hasUaFullVersion());
return member_ua_full_version_;
}
String getUaFullVersionOr(const String& fallback_value) const;
String getUaFullVersionOr(String&& fallback_value) const;
void setUaFullVersion(const String& value);
void setUaFullVersion(String&& value);

bool hasWow64() const {
  return has_wow_64_;
}
bool wow64() const {
  DCHECK(hasWow64());
return member_wow_64_;
}
bool getWow64Or(bool fallback_value) const {
  if (!hasWow64()) {
  return fallback_value;
}
return member_wow_64_;
}
void setWow64(bool value) {
  member_wow_64_ = value;
has_wow_64_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 11;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_architecture_ = false;
bool has_bitness_ = false;
bool has_brands_ = false;
bool has_form_factors_ = false;
bool has_full_version_list_ = false;
bool has_mobile_ = false;
bool has_model_ = false;
bool has_platform_ = false;
bool has_platform_version_ = false;
bool has_ua_full_version_ = false;
bool has_wow_64_ = false;

String member_architecture_;
String member_bitness_;
HeapVector<Member<NavigatorUABrandVersion>> member_brands_;
Vector<String> member_form_factors_;
HeapVector<Member<NavigatorUABrandVersion>> member_full_version_list_;
bool member_mobile_;
String member_model_;
String member_platform_;
String member_platform_version_;
String member_ua_full_version_;
bool member_wow_64_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UA_DATA_VALUES_H_
